"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RulesCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("../../../../../common/components/links");
var _constants = require("../../../../constants");
var _card_content_asset_panel = require("../common/card_content_asset_panel");
var _card_callout = require("../common/card_callout");
var _card_subdued_text = require("../common/card_subdued_text");
var i18n = _interopRequireWildcard(require("./translations"));
var _card_selector_list = require("../common/card_selector_list");
var _onboarding_context = require("../../../onboarding_context");
var _rules_card_config = require("./rules_card_config");
var _constants2 = require("./constants");
var _use_stored_state = require("../../../hooks/use_stored_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/rules/rules_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesCard = ({
  isCardComplete,
  setExpandedCardId,
  isCardAvailable
}) => {
  const {
    spaceId
  } = (0, _onboarding_context.useOnboardingContext)();
  const [selectedRuleId, setSelectedRuleId] = (0, _use_stored_state.useStoredSelectedCardItemId)('rules', spaceId, _constants2.DEFAULT_RULES_CARD_ITEM_SELECTED.id);
  const selectedCardItem = (0, _react.useMemo)(() => _rules_card_config.RULES_CARD_ITEMS_BY_ID[selectedRuleId], [selectedRuleId]);
  const isIntegrationsCardComplete = (0, _react.useMemo)(() => isCardComplete(_constants.OnboardingCardId.integrations), [isCardComplete]);
  const isIntegrationsCardAvailable = (0, _react.useMemo)(() => isCardAvailable(_constants.OnboardingCardId.integrations), [isCardAvailable]);
  const expandIntegrationsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants.OnboardingCardId.integrations, {
      scroll: true
    });
  }, [setExpandedCardId]);
  const onSelectCard = (0, _react.useCallback)(item => {
    setSelectedRuleId(item.id);
  }, [setSelectedRuleId]);
  return /*#__PURE__*/_react.default.createElement(_card_content_asset_panel.OnboardingCardContentAssetPanel, {
    asset: selectedCardItem.asset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    justifyContent: "flexStart",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_card_subdued_text.CardSubduedText, {
    "data-test-subj": "rulesCardDescription",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, i18n.RULES_CARD_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_card_selector_list.CardSelectorList, {
    title: i18n.RULES_CARD_STEP_SELECTOR_TITLE,
    items: _rules_card_config.RULES_CARD_ITEMS,
    onSelect: onSelectCard,
    selectedItem: selectedCardItem,
    cardId: _constants.OnboardingCardId.rules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }), isIntegrationsCardAvailable && !isIntegrationsCardComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "primary",
    icon: "info",
    text: i18n.RULES_CARD_CALLOUT_INTEGRATIONS_TEXT,
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: expandIntegrationsCard,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 23
      }
    }, i18n.RULES_CARD_CALLOUT_INTEGRATIONS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      color: "primary",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 25
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "rulesCardButton",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.rules,
    fill: true,
    isDisabled: isIntegrationsCardAvailable && !isIntegrationsCardComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, i18n.RULES_CARD_ADD_RULES_BUTTON))));
};

// eslint-disable-next-line import/no-default-export
exports.RulesCard = RulesCard;
var _default = exports.default = RulesCard;