"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardSelectorListStyles = void 0;
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCardSelectorListStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _css.css)`
    .cardSelectorTitle {
      font-weight: 500;
    }
    .cardSelectorContent {
      max-height: 210px;
      overflow-y: auto;
      padding: 10px 0;
    }
    .selectedCardPanelItem {
      border: 1px solid ${euiTheme.colors.primary};
      background-color: ${euiTheme.colors.backgroundBasePrimary};
    }
  `;
};
exports.useCardSelectorListStyles = useCardSelectorListStyles;