"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALIDATION_WARNINGS = exports.SELECT_OS_LABEL = exports.POLICY_SELECT_DESCRIPTION = exports.OS_OPTIONS_PLACEHOLDER = exports.OPERATOR_TITLES = exports.NAME_LABEL = exports.INPUT_ERRORS = exports.DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER = exports.DESCRIPTION_LABEL = exports.CONDITION_FIELD_TITLE = exports.CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETAILS_HEADER = exports.DETAILS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.detailsHeader', {
  defaultMessage: 'Details'
});
const DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.detailsHeaderDescription', {
  defaultMessage: 'Allow a specific external device to connect to your endpoints, even when Device Control is enabled.'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.nameLabel', {
  defaultMessage: 'Name'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.descriptionLabel', {
  defaultMessage: 'Description'
});
const CONDITIONS_HEADER = exports.CONDITIONS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.conditionsHeader', {
  defaultMessage: 'Conditions'
});
const CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.conditionsHeaderDescription', {
  defaultMessage: 'Select operating system and add conditions. Availability of conditions may depend on your chosen operating system.'
});
const SELECT_OS_LABEL = exports.SELECT_OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.selectOsLabel', {
  defaultMessage: 'Select operating system'
});
const OS_OPTIONS_PLACEHOLDER = exports.OS_OPTIONS_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.osOptionsPlaceholder', {
  defaultMessage: 'Select an operating system'
});
const POLICY_SELECT_DESCRIPTION = exports.POLICY_SELECT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.policySelectDescription', {
  defaultMessage: 'Optionally select policies to assign this trusted device to.'
});
const CONDITION_FIELD_TITLE = exports.CONDITION_FIELD_TITLE = {
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.username', {
    defaultMessage: 'Username'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.HOST]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.host', {
    defaultMessage: 'Host'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.deviceId', {
    defaultMessage: 'Device ID'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.manufacturer', {
    defaultMessage: 'Manufacturer'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_ID]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.productId', {
    defaultMessage: 'Product ID'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_NAME]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.productName', {
    defaultMessage: 'Product Name'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_TYPE]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.deviceType', {
    defaultMessage: 'Device Type'
  }),
  [_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER_ID]: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.logicalConditionBuilder.entry.field.manufacturerId', {
    defaultMessage: 'Manufacturer ID'
  })
};
const OPERATOR_TITLES = exports.OPERATOR_TITLES = {
  is: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.card.operator.is', {
    defaultMessage: 'is'
  }),
  matches: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.card.operator.matches', {
    defaultMessage: 'matches'
  })
};
const INPUT_ERRORS = exports.INPUT_ERRORS = {
  name: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.nameRequired', {
    defaultMessage: 'Trusted device name is required'
  }),
  entries: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.entriesRequired', {
    defaultMessage: 'At least one condition is required'
  }),
  invalidHash: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.invalidHash', {
    defaultMessage: 'Invalid hash value'
  }),
  invalidPath: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.invalidPath', {
    defaultMessage: 'Invalid path'
  }),
  invalidField: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.invalidField', {
    defaultMessage: 'Field entry must have a value'
  }),
  // Backend schema-aligned validation messages
  nameMaxLength: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.nameMaxLength', {
    defaultMessage: 'Name cannot exceed 256 characters'
  }),
  descriptionMaxLength: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.descriptionMaxLength', {
    defaultMessage: 'Description cannot exceed 256 characters'
  }),
  osRequired: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.osRequired', {
    defaultMessage: 'Operating system selection is required'
  }),
  entryValueEmpty: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.entryValueEmpty', {
    defaultMessage: 'Condition value cannot be empty'
  }),
  entriesAtLeastOne: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.errors.entriesAtLeastOne', {
    defaultMessage: 'At least one condition must be specified'
  })
};
const VALIDATION_WARNINGS = exports.VALIDATION_WARNINGS = {
  performanceWildcard: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.form.warnings.performanceWildcard', {
    defaultMessage: 'Double wildcards (**) may cause performance issues'
  })
};