"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIntegrationPolicyList = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetch integration policies from Fleet.
 */
const useFetchIntegrationPolicyList = (query = {}, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['fetch-integration-policy-list', query],
    refetchOnWindowFocus: false,
    ...options,
    queryFn: async () => {
      return http.get(_common.packagePolicyRouteService.getListPath(), {
        query,
        version: _common.API_VERSIONS.public.v1
      });
    }
  });
};
exports.useFetchIntegrationPolicyList = useFetchIntegrationPolicyList;