"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchEndpointPolicy = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _policy_config = require("../../../../common/endpoint/models/policy_config");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve a single endpoint integration policy (details)
 * @param policyId
 * @param options
 */
const useFetchEndpointPolicy = (policyId, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-policy-details', policyId],
    ...options,
    queryFn: async () => {
      const apiResponse = await http.get(_common.packagePolicyRouteService.getInfoPath(policyId), {
        version: _common.API_VERSIONS.public.v1
      });
      applyDefaultsToPolicyIfNeeded(apiResponse.item);
      return {
        item: apiResponse.item,
        settings: apiResponse.item.inputs[0].config.policy.value,
        artifactManifest: apiResponse.item.inputs[0].config.artifact_manifest.value
      };
    }
  });
};
exports.useFetchEndpointPolicy = useFetchEndpointPolicy;
const applyDefaultsToPolicyIfNeeded = policyItem => {
  const settings = policyItem.inputs[0].config.policy.value;

  // sets default user notification message if policy config message is empty
  if (settings.windows.popup.malware.message === '') {
    settings.windows.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
    settings.mac.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
    settings.linux.popup.malware.message = _policy_config.DefaultPolicyNotificationMessage;
  }
  if (settings.windows.popup.ransomware.message === '') {
    settings.windows.popup.ransomware.message = _policy_config.DefaultPolicyNotificationMessage;
  }
  if (settings.windows.popup.memory_protection.message === '') {
    settings.windows.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
  if (settings.mac.popup.memory_protection.message === '') {
    settings.mac.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
  if (settings.linux.popup.memory_protection.message === '') {
    settings.linux.popup.memory_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
  if (settings.windows.popup.behavior_protection.message === '') {
    settings.windows.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
  if (settings.mac.popup.behavior_protection.message === '') {
    settings.mac.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
  if (settings.linux.popup.behavior_protection.message === '') {
    settings.linux.popup.behavior_protection.message = _policy_config.DefaultPolicyRuleNotificationMessage;
  }
};