"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateArtifact = useUpdateArtifact;
var _reactQuery = require("@tanstack/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTIONS = Object.freeze({});
function useUpdateArtifact(exceptionListApiClient, customQueryOptions = DEFAULT_OPTIONS) {
  return (0, _reactQuery.useMutation)(exception => {
    return exceptionListApiClient.update(exception);
  }, customQueryOptions);
}