"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.titles = exports.descriptions = exports.PackageActionFormatter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const titles = exports.titles = Object.freeze(new Map([['es_connection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.packageActions.es_connection.title', {
  defaultMessage: 'Elasticsearch connection failure'
})], ['policy_failure', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.packageActions.policy_failure.title', {
  defaultMessage: 'Policy response failure'
})]]));
const descriptions = exports.descriptions = Object.freeze(new Map([['es_connection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.packageActions.es_connection.description', {
  defaultMessage: "The endpoint's connection to Elasticsearch is either down or misconfigured. Make sure it is configured correctly."
})], ['policy_failure', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.packageActions.policy_failure.description', {
  defaultMessage: 'The Endpoint did not apply the Policy correctly. Expand the Policy response above for more details.'
})]]));
const linkTexts = Object.freeze(new Map([['es_connection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.packageActions.link.text.es_connection', {
  defaultMessage: ' Read more.'
})]]));
class PackageActionFormatter {
  constructor(unit, docLinks) {
    var _unit$payload, _unit$payload$error, _titles$get, _unit$payload2, _unit$payload2$error;
    (0, _defineProperty2.default)(this, "key", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    (0, _defineProperty2.default)(this, "linkText", void 0);
    this.docLinks = docLinks;
    this.key = this.getKeyFromErrorCode((_unit$payload = unit.payload) === null || _unit$payload === void 0 ? void 0 : (_unit$payload$error = _unit$payload.error) === null || _unit$payload$error === void 0 ? void 0 : _unit$payload$error.code, unit.status);
    this.title = (_titles$get = titles.get(this.key)) !== null && _titles$get !== void 0 ? _titles$get : this.key;
    this.description = descriptions.get(this.key) || ((_unit$payload2 = unit.payload) === null || _unit$payload2 === void 0 ? void 0 : (_unit$payload2$error = _unit$payload2.error) === null || _unit$payload2$error === void 0 ? void 0 : _unit$payload2$error.message);
    this.linkText = linkTexts.get(this.key);
  }
  get linkUrl() {
    return this.docLinks[this.key];
  }
  getKeyFromErrorCode(code, status) {
    if (code === _constants.ENDPOINT_ERROR_CODES.ES_CONNECTION_ERROR || code === _constants.ENDPOINT_ERROR_CODES.OUTPUT_SERVER_ERROR) {
      return 'es_connection';
    } else if (status === 'FAILED' || status === 'DEGRADED') {
      return 'policy_failure';
    } else {
      throw new Error(`Invalid error code ${code}`);
    }
  }
}
exports.PackageActionFormatter = PackageActionFormatter;