"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointPoliciesToArtifactPolicies = void 0;
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _routing = require("../../../common/routing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Takes a list of EndpointPolicies (PolicyData) and turn them
 * into MenuItemPropsByPolicyId required by the artifact card.
 *
 * The resulting menu will open the policies in a new tab
 *
 */
const useEndpointPoliciesToArtifactPolicies = (policies = []) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  return (0, _react.useMemo)(() => {
    const data = policies.reduce((policiesMap, policy) => {
      var _policy$name;
      const policyId = policy.id;
      const policyDetailsPath = (0, _routing.getPolicyDetailPath)(policyId);
      policiesMap[policyId] = {
        href: getAppUrl({
          path: policyDetailsPath
        }),
        children: (_policy$name = policy.name) !== null && _policy$name !== void 0 ? _policy$name : policyId,
        target: '_blank'
      };
      return policiesMap;
    }, {});
    return data;
  }, [getAppUrl, policies]);
};
exports.useEndpointPoliciesToArtifactPolicies = useEndpointPoliciesToArtifactPolicies;