"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardArtifact = exports.CardArtifactProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/components/card_artifact_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CardArtifactContext = /*#__PURE__*/_react.default.createContext(undefined);
/**
 * Stores and provides the Artifact item that is being rendered
 */
const CardArtifactProvider = exports.CardArtifactProvider = /*#__PURE__*/(0, _react.memo)(({
  item,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(CardArtifactContext.Provider, {
    value: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 10
    }
  }, children);
});
CardArtifactProvider.displayName = 'CardArtifactProvider';

/**
 * Retrieve the artifact item (`ExceptionListItemSchema`) that is currently being rendered
 */
const useCardArtifact = () => {
  const artifact = (0, _react.useContext)(CardArtifactContext);
  if (!artifact) {
    throw new Error('Card has not been initialized correctly - missing Artifact item');
  }
  return artifact;
};
exports.useCardArtifact = useCardArtifact;