"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _context_menu_with_router_support = require("../context_menu_with_router_support");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/actions_context_menu/actions_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Display a context menu behind a icon button (which defaults to the three horizontal dots icon)
 */
const ActionsContextMenu = exports.ActionsContextMenu = /*#__PURE__*/(0, _react.memo)(({
  items,
  'data-test-subj': dataTestSubj,
  icon = 'boxesHorizontal',
  isDisabled = false,
  disabledTooltip
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleCloseMenu = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const panelProps = (0, _react.useMemo)(() => {
    return {
      'data-test-subj': getTestId('popoverPanel')
    };
  }, [getTestId]);
  const menuItems = (0, _react.useMemo)(() => {
    return items.map(itemProps => {
      return /*#__PURE__*/_react.default.createElement(_context_menu_with_router_support.ContextMenuItemNavByRouter, (0, _extends2.default)({}, itemProps, {
        key: (0, _uuid.v4)(),
        onClick: ev => {
          handleCloseMenu();
          if (itemProps.onClick) {
            return itemProps.onClick(ev);
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }));
    });
  }, [handleCloseMenu, items]);
  const menuButton = (0, _react.useMemo)(() => {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": getTestId('button'),
      iconType: icon,
      onClick: handleToggleMenu,
      isDisabled: isDisabled,
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.actionsContextMenu.label', {
        defaultMessage: 'Open'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    });
    if (isDisabled && disabledTooltip) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: disabledTooltip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 16
        }
      }, button);
    }
    return button;
  }, [disabledTooltip, getTestId, handleToggleMenu, icon, isDisabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    panelProps: panelProps,
    "data-test-subj": dataTestSubj,
    button: menuButton,
    isOpen: isOpen,
    closePopover: handleCloseMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems,
    "data-test-subj": getTestId('contextMenuPanel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }));
});
ActionsContextMenu.displayName = 'ActionsContextMenu';