"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getItems = exports.getEntityData = exports.columnsArray = exports.SUMMARY_TABLE_MIN_WIDTH = exports.LENS_VISUALIZATION_MIN_WIDTH = exports.LENS_VISUALIZATION_HEIGHT = exports.LAST_30_DAYS = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_summary_flyout/common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const columnsArray = exports.columnsArray = [{
  field: 'category',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.categoryColumnLabel",
    defaultMessage: "Category",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  footer: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.categoryColumnFooterLabel",
    defaultMessage: "Result",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  })
}, {
  field: 'score',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.scoreColumnLabel",
    defaultMessage: "Score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  dataType: 'number',
  align: 'right',
  render: _common.formatRiskScore,
  footer: props => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "risk-summary-result-score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, (0, _common.formatRiskScore)((0, _fp.sumBy)(i => i.score, props.items)))
}, {
  field: 'count',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.inputsColumnLabel",
    defaultMessage: "Inputs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  dataType: 'number',
  align: 'right',
  footer: props => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "risk-summary-result-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, (0, _fp.sumBy)(i => {
    var _i$count;
    return (_i$count = i.count) !== null && _i$count !== void 0 ? _i$count : 0;
  }, props.items))
}];
const getItems = entityData => {
  var _entityData$risk$cate, _entityData$risk$cate2, _entityData$risk$cate3;
  return [{
    category: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.alertsGroupLabel', {
      defaultMessage: 'Alerts'
    }),
    score: (_entityData$risk$cate = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_1_score) !== null && _entityData$risk$cate !== void 0 ? _entityData$risk$cate : 0,
    count: (_entityData$risk$cate2 = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_1_count) !== null && _entityData$risk$cate2 !== void 0 ? _entityData$risk$cate2 : 0
  }, {
    category: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.assetCriticalityGroupLabel', {
      defaultMessage: 'Asset Criticality'
    }),
    score: (_entityData$risk$cate3 = entityData === null || entityData === void 0 ? void 0 : entityData.risk.category_2_score) !== null && _entityData$risk$cate3 !== void 0 ? _entityData$risk$cate3 : 0,
    count: undefined
  }];
};
exports.getItems = getItems;
const getEntityData = (entityType, riskData) => {
  return riskData === null || riskData === void 0 ? void 0 : riskData[entityType];
};
exports.getEntityData = getEntityData;
const LENS_VISUALIZATION_HEIGHT = exports.LENS_VISUALIZATION_HEIGHT = 126; //  Static height in pixels specified by design
const LENS_VISUALIZATION_MIN_WIDTH = exports.LENS_VISUALIZATION_MIN_WIDTH = 160; // Lens visualization min-width in pixels
const SUMMARY_TABLE_MIN_WIDTH = exports.SUMMARY_TABLE_MIN_WIDTH = 180; // Summary table min-width in pixels
const LAST_30_DAYS = exports.LAST_30_DAYS = {
  from: 'now-30d',
  to: 'now'
};