"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.acceptSuggestedFieldValue = acceptSuggestedFieldValue;
exports.cancelFieldEdit = cancelFieldEdit;
exports.getSaveFieldValueButton = getSaveFieldValueButton;
exports.saveAndAcceptFieldValue = saveAndAcceptFieldValue;
exports.saveFieldValue = saveFieldValue;
exports.switchToFieldEdit = switchToFieldEdit;
exports.toggleFieldAccordion = toggleFieldAccordion;
var _react = require("@testing-library/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toggleFieldAccordion(fieldWrapper) {
  (0, _react.act)(() => {
    const accordionButton = (0, _react.within)(fieldWrapper).getAllByRole('button')[0];
    _react.fireEvent.click(accordionButton);
  });
}
function switchToFieldEdit(wrapper) {
  (0, _react.act)(() => {
    _react.fireEvent.click((0, _react.within)(wrapper).getByRole('button', {
      name: 'Edit'
    }));
  });
}
function cancelFieldEdit(wrapper) {
  (0, _react.act)(() => {
    _react.fireEvent.click((0, _react.within)(wrapper).getByRole('button', {
      name: 'Cancel'
    }));
  });
}
async function acceptSuggestedFieldValue(wrapper) {
  await (0, _react.act)(async () => {
    _react.fireEvent.click((0, _react.within)(wrapper).getByRole('button', {
      name: 'Accept'
    }));
  });
}
async function saveFieldValue(wrapper) {
  await clickFieldSaveButton(wrapper, 'Save');
}
async function saveAndAcceptFieldValue(wrapper) {
  await clickFieldSaveButton(wrapper, 'Save and accept');
}
function getSaveFieldValueButton(wrapper) {
  return (0, _react.within)(wrapper).getByRole('button', {
    name: 'Save'
  });
}
async function clickFieldSaveButton(wrapper, buttonName) {
  const saveButton = (0, _react.within)(wrapper).getByRole('button', {
    name: buttonName
  });
  expect(saveButton).toBeVisible();

  // Wait for async validation to finish.
  // It has been noticed some fields (like "EQL") can take more than 500ms to validate since
  // it sums up with the 300ms debounce time.
  await (0, _react.waitFor)(() => expect(saveButton).toBeEnabled(), {
    timeout: 1500
  });
  await (0, _react.act)(async () => {
    _react.fireEvent.click(saveButton);
  });

  // After saving the form "Save" button should be removed from the DOM
  await (0, _react.waitFor)(() => expect(saveButton).not.toBeInTheDocument(), {
    timeout: 500
  });
}