"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableFilters = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_rule_management_filters = require("../../../../rule_management/logic/use_rule_management_filters");
var _user_actions = require("../../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../../common/lib/apm/use_start_transaction");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _rules_table_context = require("../rules_table/rules_table_context");
var _tags_filter_popover = require("./tags_filter_popover");
var _rule_execution_status_selector = require("./rule_execution_status_selector");
var _rule_search_field = require("./rule_search_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table_filters/rules_table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeXS};
`;

/**
 * Collection of filters for filtering data within the RulesTable. Contains search bar, Elastic/Custom
 * Rules filter button toggle, and tag selection
 */
const RulesTableFiltersComponent = () => {
  var _ruleManagementFields;
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    state: {
      filterOptions
    },
    actions: {
      setFilterOptions
    }
  } = (0, _rules_table_context.useRulesTableContext)();
  const {
    data: ruleManagementFields
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const allTags = (_ruleManagementFields = ruleManagementFields === null || ruleManagementFields === void 0 ? void 0 : ruleManagementFields.aggregated_fields.tags) !== null && _ruleManagementFields !== void 0 ? _ruleManagementFields : [];
  const rulesCustomCount = ruleManagementFields === null || ruleManagementFields === void 0 ? void 0 : ruleManagementFields.rules_summary.custom_count;
  const rulesPrebuiltInstalledCount = ruleManagementFields === null || ruleManagementFields === void 0 ? void 0 : ruleManagementFields.rules_summary.prebuilt_installed_count;
  const {
    showCustomRules,
    showElasticRules,
    tags: selectedTags,
    enabled,
    ruleExecutionStatus: selectedRuleExecutionStatus
  } = filterOptions;
  const handleOnSearch = (0, _react.useCallback)(filterString => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.FILTER
    });
    setFilterOptions({
      filter: filterString.trim()
    });
  }, [setFilterOptions, startTransaction]);
  const handleElasticRulesClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.FILTER
    });
    setFilterOptions({
      showElasticRules: !showElasticRules,
      showCustomRules: false
    });
  }, [setFilterOptions, showElasticRules, startTransaction]);
  const handleCustomRulesClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.FILTER
    });
    setFilterOptions({
      showCustomRules: !showCustomRules,
      showElasticRules: false
    });
  }, [setFilterOptions, showCustomRules, startTransaction]);
  const handleShowEnabledRulesClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.FILTER
    });
    setFilterOptions(enabled === true ? {
      enabled: undefined
    } : {
      enabled: true
    });
  }, [setFilterOptions, enabled, startTransaction]);
  const handleShowDisabledRulesClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.FILTER
    });
    setFilterOptions(enabled === false ? {
      enabled: undefined
    } : {
      enabled: false
    });
  }, [setFilterOptions, enabled, startTransaction]);
  const handleSelectedTags = (0, _react.useCallback)(newTags => {
    if (!(0, _fp.isEqual)(newTags, selectedTags)) {
      startTransaction({
        name: _user_actions.RULES_TABLE_ACTIONS.FILTER
      });
      setFilterOptions({
        tags: newTags
      });
    }
  }, [selectedTags, setFilterOptions, startTransaction]);
  const handleSelectedExecutionStatus = (0, _react.useCallback)(newExecutionStatus => {
    if (newExecutionStatus !== selectedRuleExecutionStatus) {
      startTransaction({
        name: _user_actions.RULES_TABLE_ACTIONS.FILTER
      });
      setFilterOptions({
        ruleExecutionStatus: newExecutionStatus
      });
    }
  }, [selectedRuleExecutionStatus, setFilterOptions, startTransaction]);
  return /*#__PURE__*/_react.default.createElement(FilterWrapper, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_search_field.RuleSearchField, {
    initialValue: filterOptions.filter,
    onSearch: handleOnSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tags_filter_popover.TagsFilterPopover, {
    onSelectedTagsChanged: handleSelectedTags,
    selectedTags: selectedTags,
    tags: allTags,
    "data-test-subj": "allRulesTagPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_execution_status_selector.RuleExecutionStatusSelector, {
    onSelectedStatusChanged: handleSelectedExecutionStatus,
    selectedStatus: selectedRuleExecutionStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showElasticRules,
    hasActiveFilters: showElasticRules,
    onClick: handleElasticRulesClick,
    "data-test-subj": "showElasticRulesFilterButton",
    withNext: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, i18n.ELASTIC_RULES, rulesPrebuiltInstalledCount != null ? ` (${rulesPrebuiltInstalledCount !== null && rulesPrebuiltInstalledCount !== void 0 ? rulesPrebuiltInstalledCount : ''})` : ''), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showCustomRules,
    hasActiveFilters: showCustomRules,
    onClick: handleCustomRulesClick,
    "data-test-subj": "showCustomRulesFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, i18n.CUSTOM_RULES, rulesCustomCount != null ? ` (${rulesCustomCount})` : ''))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: enabled === true,
    hasActiveFilters: enabled === true,
    onClick: handleShowEnabledRulesClick,
    "data-test-subj": "showEnabledRulesFilterButton",
    withNext: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, i18n.ENABLED_RULES), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: enabled === false,
    hasActiveFilters: enabled === false,
    onClick: handleShowDisabledRulesClick,
    "data-test-subj": "showDisabledRulesFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, i18n.DISABLED_RULES))));
};
RulesTableFiltersComponent.displayName = 'RulesTableFiltersComponent';
const RulesTableFilters = exports.RulesTableFilters = /*#__PURE__*/_react.default.memo(RulesTableFiltersComponent);
RulesTableFilters.displayName = 'RulesTableFilters';