"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerFieldRuleDiffTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _get_formatted_field_diff = require("./per_field_diff/get_formatted_field_diff");
var _constants = require("./constants");
var _diff_components = require("./diff_components");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/per_field_rule_diff_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PerFieldRuleDiffTab = ({
  ruleDiff,
  header,
  leftDiffSideLabel,
  rightDiffSideLabel,
  leftDiffSideDescription,
  rightDiffSideDescription,
  diffLayout
}) => {
  const fieldsToRender = (0, _react.useMemo)(() => {
    const fields = [];
    // Filter out diff outcomes that we don't support displaying in the per-field diff flyout
    const filteredFieldDiffs = (0, _helpers.filterUnsupportedDiffOutcomes)(ruleDiff.fields);
    for (const field of Object.keys(filteredFieldDiffs)) {
      const typedField = field;
      const formattedDiffs = (0, _get_formatted_field_diff.getFormattedFieldDiffGroups)(typedField, filteredFieldDiffs);
      fields.push({
        formattedDiffs,
        fieldsGroupName: typedField
      });
    }
    const sortedFields = fields.sort((a, b) => _constants.UPGRADE_FIELD_ORDER.indexOf(a.fieldsGroupName) - _constants.UPGRADE_FIELD_ORDER.indexOf(b.fieldsGroupName));
    return sortedFields;
  }, [ruleDiff.fields]);
  const {
    aboutFields,
    definitionFields,
    scheduleFields,
    setupFields
  } = (0, _react.useMemo)(() => (0, _helpers.getSectionedFieldDiffs)(fieldsToRender), [fieldsToRender]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffHeaderBar, {
    leftDiffSideLabel: leftDiffSideLabel,
    rightDiffSideLabel: rightDiffSideLabel,
    leftDiffSideDescription: leftDiffSideDescription,
    rightDiffSideDescription: rightDiffSideDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), header, aboutFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.ABOUT_SECTION_LABEL,
    fieldGroups: aboutFields,
    diffLayout: diffLayout,
    dataTestSubj: "perFieldDiffAboutSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), definitionFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.DEFINITION_SECTION_LABEL,
    fieldGroups: definitionFields,
    diffLayout: diffLayout,
    dataTestSubj: "perFieldDiffDefinitionSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), scheduleFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.SCHEDULE_SECTION_LABEL,
    fieldGroups: scheduleFields,
    diffLayout: diffLayout,
    dataTestSubj: "perFieldDiffScheduleSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }), setupFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.SETUP_GUIDE_SECTION_LABEL,
    fieldGroups: setupFields,
    diffLayout: diffLayout,
    dataTestSubj: "perFieldDiffSetupSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }));
};
exports.PerFieldRuleDiffTab = PerFieldRuleDiffTab;