"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkFillRuleGapsModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _schedule_bulk_action_modal = require("../../../common/components/schedule_bulk_action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/bulk_fill_rule_gaps/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const modalCopy = {
  modalTitle: i18n.BULK_FILL_RULE_GAPS_MODAL_TITLE,
  timeRangeTitle: i18n.BULK_FILL_RULE_GAPS_TIME_RANGE_TITLE,
  confirmButton: i18n.BULK_FILL_RULE_GAPS_CONFIRM_BUTTON,
  cancelButton: i18n.BULK_FILL_RULE_GAPS_CANCEL_BUTTON,
  errors: {
    startDateOutOfRange: i18n.BULK_FILL_RULE_GAPS_START_DATE_OUT_OF_RANGE_ERROR(_constants.MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS),
    endDateInFuture: i18n.BULK_FILL_RULE_GAPS_FUTURE_TIME_RANGE_ERROR,
    invalidTimeRange: i18n.BULK_FILL_RULE_GAPS_INVALID_TIME_RANGE_ERROR
  }
};
const BulkFillRuleGapsModalComponent = ({
  onCancel,
  onConfirm,
  rulesCount
}) => {
  const callouts = (0, _react.useMemo)(() => {
    const components = [/*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      iconType: "warning",
      title: i18n.BULK_FILL_RULE_GAPS_NOTIFICATIONS_LIMITATIONS,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    })];
    if (rulesCount > 1) {
      components.push(/*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        iconType: "warning",
        title: i18n.BULK_FILL_RULE_GAPS_MAX_GAPS_LIMITATIONS,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 9
        }
      }));
    }
    return components;
  }, [rulesCount]);
  return /*#__PURE__*/_react.default.createElement(_schedule_bulk_action_modal.ScheduleBulkActionModal, {
    onCancel: onCancel,
    onConfirm: onConfirm,
    text: modalCopy,
    maxLookbackWindowDays: _constants.MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS,
    callouts: callouts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
};
const BulkFillRuleGapsModal = exports.BulkFillRuleGapsModal = /*#__PURE__*/_react.default.memo(BulkFillRuleGapsModalComponent);
BulkFillRuleGapsModal.displayName = 'BulkFillRuleGapsModal';