"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFindGapsQuery = exports.useFindGapsForRule = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIND_GAPS_FOR_RULE = 'FIND_GAP_FOR_RULE';
const useInvalidateFindGapsQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries([FIND_GAPS_FOR_RULE], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFindGapsQuery = useInvalidateFindGapsQuery;
const useFindGapsForRule = ({
  ruleId,
  page,
  perPage,
  start,
  end,
  statuses,
  sortField,
  sortOrder
}, options) => {
  return (0, _reactQuery.useQuery)([FIND_GAPS_FOR_RULE, ruleId, page, perPage, statuses === null || statuses === void 0 ? void 0 : statuses.join(','), sortField, sortOrder, start, end], async ({
    signal
  }) => {
    const response = await (0, _api.findGapsForRule)({
      signal,
      ruleId,
      page,
      perPage,
      start,
      end,
      statuses,
      sortField: sortField,
      sortOrder
    });
    return response;
  }, {
    retry: 0,
    keepPreviousData: true,
    ...options
  });
};
exports.useFindGapsForRule = useFindGapsForRule;