"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkListSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_to_lists_table/link_list_switch/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkListSwitch = exports.LinkListSwitch = /*#__PURE__*/(0, _react.memo)(({
  list,
  linkedList,
  onListLinkChange,
  dataTestSubj
}) => {
  const isListLinked = (0, _react.useMemo)(() => Boolean(linkedList.find(l => l.id === list.id)), [linkedList, list.id]);
  const onLinkOrUnlinkList = (0, _react.useCallback)(({
    target: {
      checked
    }
  }) => {
    const newLinkedLists = !checked ? linkedList === null || linkedList === void 0 ? void 0 : linkedList.filter(item => item.id !== list.id) : [...linkedList, list];
    if (typeof onListLinkChange === 'function') onListLinkChange(newLinkedLists);
  }, [linkedList, onListLinkChange, list]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": dataTestSubj,
    onChange: onLinkOrUnlinkList,
    checked: isListLinked,
    label: i18n.LINK_LIST_SWITCH_ARIA_LABEL(list.name),
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }));
});
LinkListSwitch.displayName = 'LinkListSwitch';