"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyUrlConflictCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/legacy_url_conflict_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LegacyUrlConflictCallOut = exports.LegacyUrlConflictCallOut = /*#__PURE__*/_react.default.memo(({
  rule,
  spacesApi
}) => {
  if ((rule === null || rule === void 0 ? void 0 : rule.alias_target_id) != null && spacesApi && rule.outcome === 'conflict') {
    const aliasTargetId = rule.alias_target_id;
    // We have resolved to one rule, but there is another one with a legacy URL associated with this page. Display a
    // callout with a warning for the user, and provide a way for them to navigate to the other rule.
    const otherRulePath = `rules/id/${aliasTargetId}${window.location.search}${window.location.hash}`;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "legacyUrlConflictCallOut-wrapper",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 11
      }
    }), spacesApi.ui.components.getLegacyUrlConflict({
      objectNoun: _i18n.i18n.translate('xpack.securitySolution.sections.ruleDetails.redirectObjectNoun', {
        defaultMessage: 'rule'
      }),
      currentObjectId: rule.id,
      otherObjectId: aliasTargetId,
      otherObjectPath: otherRulePath
    }));
  }
  return null;
});
LegacyUrlConflictCallOut.displayName = 'LegacyUrlConflictCallOut';