"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.operatorContainer = exports.mainContainer = exports.input = exports.dropdownContainer = exports.FieldSectionGroup = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONTAINER_BREAKPOINT = 500;
const mainContainer = exports.mainContainer = (0, _css.css)`
  container-type: inline-size;
`;
const baseStyle = (0, _css.css)`
  flex-basis: 100%;
`;
const dropdownContainer = exports.dropdownContainer = (0, _css.cx)(baseStyle, (0, _css.css)`
    @container (min-width: ${CONTAINER_BREAKPOINT}px) {
      flex: 1;
      min-width: 0; /* Allows the dropdown to shrink */
    }
  `);
const operatorContainer = exports.operatorContainer = (0, _css.cx)(baseStyle, (0, _css.css)`
    justify-content: center;
    text-align: center;

    @container (min-width: ${CONTAINER_BREAKPOINT}px) {
      align-self: center;
      justify-content: flex-start;
      flex: 0 0 auto;
    }
  `);
const input = exports.input = (0, _css.cx)(baseStyle, (0, _css.css)`
    @container (min-width: ${CONTAINER_BREAKPOINT}px) {
      flex: 0 0 150px;
    }
  `);
const FieldSectionGroup = exports.FieldSectionGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  gap: ${({
  theme
}) => theme.euiTheme.size.s};
  flex-wrap: wrap;

  @container (min-width: ${CONTAINER_BREAKPOINT}px) {
    flex-wrap: nowrap;
    gap: ${({
  theme
}) => theme.euiTheme.size.l};
  }
`;