"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedRequestsQueryComponent = exports.LoggedRequestsQuery = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/logged_requests_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LoggedRequestsQueryComponent = ({
  description,
  duration,
  request
}) => {
  const paddingLarge = (0, _eui.useEuiPaddingSize)('l');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      'padding-left': paddingLarge
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "preview-logged-request-description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }, description !== null && description !== void 0 ? description : null, " ", duration ? `[${duration}ms]` : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }), request ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: 300,
    isVirtualized: true,
    "data-test-subj": "preview-logged-request-code-block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, request) : null);
};
exports.LoggedRequestsQueryComponent = LoggedRequestsQueryComponent;
const LoggedRequestsQuery = exports.LoggedRequestsQuery = /*#__PURE__*/_react.default.memo(LoggedRequestsQueryComponent);
LoggedRequestsQuery.displayName = 'LoggedRequestsQuery';