"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../shared_imports");
var _required_fields_help_info = require("./required_fields_help_info");
var defineRuleI18n = _interopRequireWildcard(require("../../../rule_creation_ui/components/step_define_rule/translations"));
var _optional_field_label = require("../optional_field_label");
var _required_fields_row = require("./required_fields_row");
var _utils = require("../utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/required_fields/required_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RequiredFieldsComponent = ({
  path,
  indexPatternFields = [],
  isIndexPatternLoading = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseArray, {
    path: path,
    initialNumberOfItems: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, ({
    items,
    addItem,
    removeItem,
    form
  }) => /*#__PURE__*/_react.default.createElement(RequiredFieldsList, {
    items: items,
    addItem: addItem,
    removeItem: removeItem,
    indexPatternFields: indexPatternFields,
    isIndexPatternLoading: isIndexPatternLoading,
    path: path,
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }));
};
const RequiredFieldsList = ({
  items,
  addItem,
  removeItem,
  indexPatternFields,
  isIndexPatternLoading,
  path,
  form
}) => {
  var _formData$path;
  /*
    This component should only re-render when either the "index" form field (index patterns) or the required fields change.
     By default, the `useFormData` hook triggers a re-render whenever any form field changes.
    It also allows optimization by passing a "watch" array of field names. The component then only re-renders when these specified fields change.
     However, it doesn't work with fields created using the `UseArray` component.
    In `useFormData`, these array fields are stored as "flattened" objects with numbered keys, like { "requiredFields[0]": { ... }, "requiredFields[1]": { ... } }.
    The "watch" feature of `useFormData` only works if you pass these "flattened" field names, such as ["requiredFields[0]", "requiredFields[1]", ...], not just "requiredFields".
     To work around this, we manually construct a list of "flattened" field names to watch, based on the current state of the form.
    This is a temporary solution and ideally, `useFormData` should be updated to handle this scenario.
  */
  const flattenedFieldNames = (0, _utils.getFlattenedArrayFieldNames)(form, path);

  /*
    Not using "watch" for the initial render, to let row components render and initialize form fields.
    Then we can use the "watch" feature to track their changes.
  */
  const hasRenderedInitially = flattenedFieldNames.length > 0;
  const fieldsToWatch = hasRenderedInitially ? ['index', ...flattenedFieldNames] : [];
  const [formData] = (0, _shared_imports.useFormData)({
    watch: fieldsToWatch
  });
  const fieldValue = (_formData$path = formData[path]) !== null && _formData$path !== void 0 ? _formData$path : [];
  const typesByFieldName = (0, _react.useMemo)(() => indexPatternFields.reduce((accumulator, field) => {
    var _field$esTypes;
    if ((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.length) {
      accumulator[field.name] = field.esTypes;
    }
    return accumulator;
  }, {}), [indexPatternFields]);
  const allFieldNames = (0, _react.useMemo)(() => Object.keys(typesByFieldName), [typesByFieldName]);
  const selectedFieldNames = fieldValue.map(({
    name
  }) => name);
  const availableFieldNames = allFieldNames.filter(name => !selectedFieldNames.includes(name));
  const nameWarnings = fieldValue.reduce((warnings, {
    name
  }) => {
    if (!isIndexPatternLoading && /* Creating a warning only if "name" value is filled in */
    name !== '' && !allFieldNames.includes(name)) {
      warnings[name] = i18n.FIELD_NAME_NOT_FOUND_WARNING(name);
    }
    return warnings;
  }, {});
  const typeWarnings = fieldValue.reduce((warnings, {
    name,
    type
  }) => {
    if (!isIndexPatternLoading && /* Creating a warning for "type" only if "name" value is filled in */
    name !== '' && typesByFieldName[name] && !typesByFieldName[name].includes(type)) {
      warnings[`${name}-${type}`] = i18n.FIELD_TYPE_NOT_FOUND_WARNING(name, type);
    }
    return warnings;
  }, {});
  const getWarnings = ({
    name,
    type
  }) => ({
    nameWarning: nameWarnings[name] || '',
    typeWarning: typeWarnings[`${name}-${type}`] || ''
  });
  const hasEmptyFieldName = fieldValue.some(({
    name
  }) => name === '');
  const hasWarnings = Object.keys(nameWarnings).length > 0 || Object.keys(typeWarnings).length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasWarnings && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.REQUIRED_FIELDS_GENERAL_WARNING_TITLE,
    color: "warning",
    iconType: "question",
    "data-test-subj": "requiredFieldsGeneralWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.generalWarningDescription",
    defaultMessage: "This doesn't break rule execution, but it might indicate that required fields were set incorrectly. Please check that indices specified in the rule's {source} exist and have expected fields and types in mappings.",
    values: {
      source: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 25
        }
      }, defineRuleI18n.SOURCE)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.REQUIRED_FIELDS_LABEL, /*#__PURE__*/_react.default.createElement(_required_fields_help_info.RequiredFieldsHelpInfo, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, _optional_field_label.OptionalFieldLabel),
    hasChildLabel: false,
    labelType: "legend",
    "data-test-subj": "requiredFieldsFormRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(item => /*#__PURE__*/_react.default.createElement(_required_fields_row.RequiredFieldRow, {
    key: item.id,
    item: item,
    removeItem: removeItem,
    getWarnings: getWarnings,
    typesByFieldName: typesByFieldName,
    availableFieldNames: availableFieldNames,
    parentFieldPath: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "plusInCircle",
    onClick: addItem,
    isDisabled: isIndexPatternLoading || hasEmptyFieldName,
    "data-test-subj": "addRequiredFieldButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, i18n.ADD_REQUIRED_FIELD))));
};
const RequiredFields = exports.RequiredFields = /*#__PURE__*/_react.default.memo(RequiredFieldsComponent);