"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameComboBox = NameComboBox;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/required_fields/name_combobox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NameComboBox({
  field,
  itemId,
  availableFieldNames,
  typesByFieldName,
  nameWarning,
  nameError
}) {
  const {
    value,
    setValue
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectableNameOptions = (0, _react.useMemo)(() => /* Not adding an empty string to the list of selectable field names */
  (value.name ? [value.name] : []).concat(availableFieldNames).map(name => ({
    label: name,
    value: name
  })), [availableFieldNames, value.name]);

  /*
    Using a state for `selectedNameOptions` instead of using the field value directly
    to fix the issue where pressing the backspace key in combobox input would clear the field value
    and trigger a validation error. By using a separate state, we can clear the selected option
    without clearing the field value.
  */
  const [selectedNameOption, setSelectedNameOption] = (0, _react.useState)(selectableNameOptions.find(option => option.label === value.name));
  (0, _react.useEffect)(() => {
    /* Re-computing the new selected name option when the field value changes */
    setSelectedNameOption(selectableNameOptions.find(option => option.label === value.name));
  }, [value.name, selectableNameOptions]);
  const handleNameChange = (0, _react.useCallback)(selectedOptions => {
    const newlySelectedOption = selectedOptions[0];
    if (!newlySelectedOption) {
      /* This occurs when the user hits backspace in combobox */
      setSelectedNameOption(undefined);
      return;
    }
    const updatedName = (newlySelectedOption === null || newlySelectedOption === void 0 ? void 0 : newlySelectedOption.value) || '';
    const updatedType = (0, _utils.pickTypeForName)({
      name: updatedName,
      type: value.type,
      typesByFieldName
    });
    const updatedFieldValue = {
      name: updatedName,
      type: updatedType
    };
    setValue(updatedFieldValue);
  }, [setValue, value.type, typesByFieldName]);
  const handleAddCustomName = (0, _react.useCallback)(newName => {
    const updatedFieldValue = {
      name: newName,
      type: (0, _utils.pickTypeForName)({
        name: newName,
        type: value.type,
        typesByFieldName
      })
    };
    setValue(updatedFieldValue);
  }, [setValue, value.type, typesByFieldName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `requiredFieldNameSelect-${value.name || 'empty'}`,
    "aria-label": i18n.FIELD_NAME,
    placeholder: i18n.FIELD_NAME,
    singleSelection: {
      asPlainText: true
    },
    options: selectableNameOptions,
    selectedOptions: selectedNameOption ? [selectedNameOption] : [],
    onChange: handleNameChange,
    isClearable: false,
    onCreateOption: handleAddCustomName,
    isInvalid: Boolean(nameError),
    prepend: nameWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "warning",
      color: euiTheme.colors.textWarning,
      "data-test-subj": "warningIcon",
      "aria-labelledby": `warningText-${itemId}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  });
}