"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPathParamToUrl = exports.RETURN_PATH = exports.RETURN_APP_ID = void 0;
var _queryString = require("query-string");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RETURN_APP_ID = exports.RETURN_APP_ID = 'returnAppId';
const RETURN_PATH = exports.RETURN_PATH = 'returnPath';
const addPathParamToUrl = (url, onboardingLink, extraParams) => {
  return (0, _queryString.stringifyUrl)({
    url,
    query: {
      [RETURN_APP_ID]: _common.APP_UI_ID,
      [RETURN_PATH]: onboardingLink,
      ...extraParams
    }
  }, {
    encode: true,
    sort: false
  });
};
exports.addPathParamToUrl = addPathParamToUrl;