"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkAlertClosingReasonItems = exports.ALERT_CLOSING_REASON_PANEL_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alert_bulk_closing_reason = require("./alert_bulk_closing_reason");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/use_bulk_alert_closing_reason_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_CLOSING_REASON_PANEL_ID = exports.ALERT_CLOSING_REASON_PANEL_ID = 'ALERT_CLOSING_REASON_PANEL_ID';
/**
 * Returns items and panels to be used in a EuiContextMenu component
 */
const useBulkAlertClosingReasonItems = ({
  onSubmitCloseReason
} = {}) => {
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const item = (0, _react.useMemo)(() => hasIndexWrite ? {
    key: 'close-alert-with-reason',
    'data-test-subj': 'alert-close-context-menu-item',
    label: i18n.BULK_ACTION_CLOSE_SELECTED,
    panel: ALERT_CLOSING_REASON_PANEL_ID
  } : undefined, [hasIndexWrite]);
  const getRenderContent = (0, _react.useCallback)(({
    onSubmitCloseReason: onSubmitCloseReasonCb
  }) => {
    function renderContent(renderProps) {
      const handleSubmit = reason => {
        onSubmitCloseReasonCb === null || onSubmitCloseReasonCb === void 0 ? void 0 : onSubmitCloseReasonCb({
          ...renderProps,
          reason
        });
      };
      return /*#__PURE__*/_react.default.createElement(_alert_bulk_closing_reason.BulkAlertClosingReason, {
        onSubmit: handleSubmit,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 16
        }
      });
    }
    return renderContent;
  }, []);
  const panels = (0, _react.useMemo)(() => hasIndexWrite ? [{
    id: ALERT_CLOSING_REASON_PANEL_ID,
    title: i18n.ALERT_CLOSING_REASON_MENU_TITLE,
    renderContent: getRenderContent({
      onSubmitCloseReason
    })
  }] : [], [hasIndexWrite, getRenderContent, onSubmitCloseReason]);

  /**
   * function to use instead of `panels` in case we need to
   * pass the `onSubmitCloseReason` at run time
   */
  const getPanels = (0, _react.useCallback)(({
    onSubmitCloseReason: onSubmitCloseReasonCb
  }) => hasIndexWrite ? [{
    id: ALERT_CLOSING_REASON_PANEL_ID,
    title: i18n.ALERT_CLOSING_REASON_MENU_TITLE,
    renderContent: getRenderContent({
      onSubmitCloseReason: onSubmitCloseReasonCb
    })
  }] : [], [getRenderContent, hasIndexWrite]);
  return (0, _react.useMemo)(() => ({
    item,
    panels,
    getPanels
  }), [item, panels, getPanels]);
};
exports.useBulkAlertClosingReasonItems = useBulkAlertClosingReasonItems;