"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetchByRestartingSession = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_selector = require("../../hooks/use_selector");
var _kibana = require("../../lib/kibana");
var _store = require("../../store");
var _actions = require("../../store/actions");
var _constants = require("../../store/inputs/constants");
var _timeline = require("../../../../common/types/timeline");
var _selectors = require("../../../timelines/store/selectors");
var _defaults = require("../../../timelines/store/defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefetchByRestartingSession = ({
  inputId,
  queryId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const session = (0, _react.useRef)(data.search.session);
  const getGlobalQuery = (0, _react.useMemo)(() => _store.inputsSelectors.globalQueryByIdSelector(), []);
  const getTimelineQuery = (0, _react.useMemo)(() => _store.inputsSelectors.timelineQueryByIdSelectorFactory(), []);
  const {
    activeTab
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTimelineById;
    return (_selectTimelineById = (0, _selectors.selectTimelineById)(state, _timeline.TimelineId.active)) !== null && _selectTimelineById !== void 0 ? _selectTimelineById : _defaults.timelineDefaults;
  });
  const {
    selectedInspectIndex
  } = (0, _use_selector.useDeepEqualSelector)(state => inputId === _constants.InputsModelId.global ? getGlobalQuery(state, queryId) : getTimelineQuery(state, `${_timeline.TimelineId.active}-${activeTab}`));
  const refetchByRestartingSession = (0, _react.useCallback)(() => {
    const searchSessionId = session.current.start();
    dispatch(_actions.inputsActions.setInspectionParameter({
      id: queryId,
      selectedInspectIndex,
      isInspected: false,
      inputId: _constants.InputsModelId.global,
      /** Lens Embeddables do not have a function we can call to refetch data
       * like most of our components, it refetches when receiving a new search
       * session ID.
       **/
      searchSessionId
    }));
  }, [dispatch, queryId, selectedInspectIndex]);

  /**
   * This is for refetching alert index when the first rule just created
   */
  const refetchByDeletingSession = (0, _react.useCallback)(() => {
    dispatch(_actions.inputsActions.deleteOneQuery({
      inputId: _constants.InputsModelId.global,
      id: queryId
    }));
  }, [dispatch, queryId]);
  return {
    session,
    refetchByRestartingSession,
    refetchByDeletingSession
  };
};
exports.useRefetchByRestartingSession = useRefetchByRestartingSession;