"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityToKql = exports.entitiesToKql = exports.addEntitiesToKql = void 0;
var _rison = require("@kbn/rison");
var _rison_helpers = require("./rison_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityToKql = (entityNames, entity) => {
  if (entityNames.length === 1) {
    return `${entityNames[0]}: "${entity}"`;
  } else {
    return entityNames.reduce((accum, entityName, index, array) => {
      if (index === 0) {
        return `(${entityName}: "${entity}"`;
      } else if (index === array.length - 1) {
        return `${accum} or ${entityName}: "${entity}")`;
      } else {
        return `${accum} or ${entityName}: "${entity}"`;
      }
    }, '');
  }
};
exports.entityToKql = entityToKql;
const entitiesToKql = (entityNames, entities) => {
  return entities.reduce((accum, entity, index) => {
    const entityKql = entityToKql(entityNames, entity);
    if (index === 0) {
      return entityKql;
    } else {
      return `${accum} or ${entityKql}`;
    }
  }, '');
};
exports.entitiesToKql = entitiesToKql;
const addEntitiesToKql = (entityNames, entities, kqlQuery) => {
  const value = (0, _rison_helpers.decodeRison)(kqlQuery);
  if ((0, _rison_helpers.isRisonObject)(value)) {
    const appQuery = value;
    if ((0, _rison_helpers.isRisonObject)(appQuery)) {
      if ((0, _rison_helpers.isRegularString)(appQuery.query)) {
        const entitiesKql = entitiesToKql(entityNames, entities);
        if (appQuery.query !== '' && entitiesKql !== '') {
          appQuery.query = `(${entitiesKql}) and (${appQuery.query})`;
        } else if (appQuery.query === '' && entitiesKql !== '') {
          appQuery.query = `(${entitiesKql})`;
        }
        return (0, _rison.encode)(value);
      }
    }
  } else if (value == null) {
    const entitiesKql = entitiesToKql(entityNames, entities);
    return (0, _rison.encode)({
      query: `(${entitiesKql})`,
      language: 'kuery'
    });
  }
  return kqlQuery;
};
exports.addEntitiesToKql = addEntitiesToKql;