"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DRAG_TYPE_FIELD", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.DRAG_TYPE_FIELD;
  }
});
Object.defineProperty(exports, "IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME;
  }
});
exports.allowTopN = exports.addProviderToTimeline = exports.addFieldToColumns = void 0;
Object.defineProperty(exports, "destinationIsTimelineButton", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.destinationIsTimelineButton;
  }
});
Object.defineProperty(exports, "destinationIsTimelineColumns", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.destinationIsTimelineColumns;
  }
});
Object.defineProperty(exports, "destinationIsTimelineProviders", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.destinationIsTimelineProviders;
  }
});
Object.defineProperty(exports, "draggableContentPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableContentPrefix;
  }
});
Object.defineProperty(exports, "draggableFieldPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableFieldPrefix;
  }
});
Object.defineProperty(exports, "draggableIdPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableIdPrefix;
  }
});
Object.defineProperty(exports, "draggableIsContent", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableIsContent;
  }
});
Object.defineProperty(exports, "draggableIsField", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableIsField;
  }
});
Object.defineProperty(exports, "draggableTimelineProvidersPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.draggableTimelineProvidersPrefix;
  }
});
Object.defineProperty(exports, "droppableContentPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableContentPrefix;
  }
});
Object.defineProperty(exports, "droppableFieldPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableFieldPrefix;
  }
});
Object.defineProperty(exports, "droppableIdPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableIdPrefix;
  }
});
Object.defineProperty(exports, "droppableTimelineColumnsPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableTimelineColumnsPrefix;
  }
});
Object.defineProperty(exports, "droppableTimelineFlyoutBottomBarPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableTimelineFlyoutBottomBarPrefix;
  }
});
Object.defineProperty(exports, "droppableTimelineProvidersPrefix", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.droppableTimelineProvidersPrefix;
  }
});
Object.defineProperty(exports, "escapeContextId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.escapeContextId;
  }
});
Object.defineProperty(exports, "escapeDataProviderId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.escapeDataProviderId;
  }
});
Object.defineProperty(exports, "escapeFieldId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.escapeFieldId;
  }
});
Object.defineProperty(exports, "fieldWasDroppedOnTimelineColumns", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.fieldWasDroppedOnTimelineColumns;
  }
});
Object.defineProperty(exports, "getDraggableFieldId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getDraggableFieldId;
  }
});
Object.defineProperty(exports, "getDraggableId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getDraggableId;
  }
});
Object.defineProperty(exports, "getDroppableId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getDroppableId;
  }
});
Object.defineProperty(exports, "getFieldIdFromDraggable", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getFieldIdFromDraggable;
  }
});
exports.getIdFromColumnDroppableId = void 0;
Object.defineProperty(exports, "getProviderIdFromDraggable", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getProviderIdFromDraggable;
  }
});
Object.defineProperty(exports, "getTimelineProviderDraggableId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getTimelineProviderDraggableId;
  }
});
Object.defineProperty(exports, "getTimelineProviderDroppableId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.getTimelineProviderDroppableId;
  }
});
Object.defineProperty(exports, "providerWasDroppedOnTimeline", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.providerWasDroppedOnTimeline;
  }
});
Object.defineProperty(exports, "reasonIsDrop", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.reasonIsDrop;
  }
});
Object.defineProperty(exports, "sourceAndDestinationAreSameTimelineProviders", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.sourceAndDestinationAreSameTimelineProviders;
  }
});
Object.defineProperty(exports, "sourceIsContent", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.sourceIsContent;
  }
});
Object.defineProperty(exports, "unEscapeFieldId", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.unEscapeFieldId;
  }
});
Object.defineProperty(exports, "userIsReArrangingProviders", {
  enumerable: true,
  get: function () {
    return _securitysolutionTGrid.userIsReArrangingProviders;
  }
});
var _fp = require("lodash/fp");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../timelines/components/timeline/body/constants");
var _helpers = require("../../../helpers");
var _actions = require("../../store/actions");
var _helpers2 = require("../../../timelines/components/timeline/data_providers/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addProviderToTimeline = ({
  activeTimelineDataProviders,
  dataProviders,
  dispatch,
  result,
  timelineId,
  noProviderFound = _actions.dragAndDropActions.noProviderFound,
  onAddedToTimeline
}) => {
  const providerId = (0, _securitysolutionTGrid.getProviderIdFromDraggable)(result);
  const providerToAdd = dataProviders[providerId];
  if (providerToAdd) {
    (0, _helpers2.addContentToTimeline)({
      dataProviders: activeTimelineDataProviders,
      destination: result.destination,
      dispatch,
      onAddedToTimeline,
      providerToAdd,
      timelineId
    });
  } else {
    dispatch(noProviderFound({
      id: providerId
    }));
  }
};
exports.addProviderToTimeline = addProviderToTimeline;
const allowTopN = ({
  isAggregatable,
  fieldType,
  fieldName,
  hideTopN
}) => {
  const isAllowedType = ['boolean', 'geo-point', 'geo-shape', 'ip', 'keyword', 'number', 'numeric', 'string'].includes(fieldType);

  // TODO: remove this explicit allowlist when the ECS documentation includes alerts
  const isAllowlistedNonBrowserField = ['kibana.alert.ancestors.depth', 'kibana.alert.ancestors.id', 'kibana.alert.ancestors.rule', 'kibana.alert.ancestors.type', 'kibana.alert.original_event.action', 'kibana.alert.original_event.category', 'kibana.alert.original_event.code', 'kibana.alert.original_event.created', 'kibana.alert.original_event.dataset', 'kibana.alert.original_event.duration', 'kibana.alert.original_event.end', 'kibana.alert.original_event.hash', 'kibana.alert.original_event.id', 'kibana.alert.original_event.kind', 'kibana.alert.original_event.module', 'kibana.alert.original_event.original', 'kibana.alert.original_event.outcome', 'kibana.alert.original_event.provider', 'kibana.alert.original_event.risk_score', 'kibana.alert.original_event.risk_score_norm', 'kibana.alert.original_event.sequence', 'kibana.alert.original_event.severity', 'kibana.alert.original_event.start', 'kibana.alert.original_event.timezone', 'kibana.alert.original_event.type', 'kibana.alert.original_time', 'kibana.alert.rule.created_by', 'kibana.alert.rule.description', 'kibana.alert.rule.enabled', 'kibana.alert.rule.false_positives', 'kibana.alert.rule.from', 'kibana.alert.rule.uuid', 'kibana.alert.rule.immutable', 'kibana.alert.rule.interval', 'kibana.alert.rule.max_signals', 'kibana.alert.rule.name', 'kibana.alert.rule.note', 'kibana.alert.rule.references', 'kibana.alert.risk_score', 'kibana.alert.rule.rule_id', 'kibana.alert.severity', 'kibana.alert.rule.size', 'kibana.alert.rule.tags', 'kibana.alert.rule.threat', 'kibana.alert.rule.threat.tactic.id', 'kibana.alert.rule.threat.tactic.name', 'kibana.alert.rule.threat.tactic.reference', 'kibana.alert.rule.threat.technique.id', 'kibana.alert.rule.threat.technique.name', 'kibana.alert.rule.threat.technique.reference', 'kibana.alert.rule.timeline_id', 'kibana.alert.rule.timeline_title', 'kibana.alert.rule.to', 'kibana.alert.rule.type', 'kibana.alert.rule.updated_by', 'kibana.alert.rule.version', 'kibana.alert.workflow_status'].includes(fieldName);
  if (hideTopN) {
    return false;
  }
  return isAllowlistedNonBrowserField || isAggregatable && isAllowedType;
};
exports.allowTopN = allowTopN;
const getAllBrowserFields = browserFields => Object.values(browserFields).reduce((acc, namespace) => [...acc, ...Object.values(namespace.fields != null ? namespace.fields : {})], []);
const getAllFieldsByName = browserFields => (0, _fp.keyBy)('name', getAllBrowserFields(browserFields));
const linkFields = {
  'kibana.alert.rule.name': 'kibana.alert.rule.uuid',
  'event.module': 'rule.reference'
};
const addFieldToColumns = ({
  browserFields,
  dispatch,
  result,
  scopeId,
  defaultsHeader
}) => {
  var _defaultsHeader$find;
  const fieldId = (0, _securitysolutionTGrid.getFieldIdFromDraggable)(result);
  const allColumns = getAllFieldsByName(browserFields);
  const column = allColumns[fieldId];
  const initColumnHeader = scopeId === _securitysolutionDataTable.TableId.alertsOnAlertsPage || scopeId === _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage ? (_defaultsHeader$find = defaultsHeader.find(c => c.id === fieldId)) !== null && _defaultsHeader$find !== void 0 ? _defaultsHeader$find : {} : {};
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);
  if (column != null && scopedActions) {
    var _linkFields$fieldId;
    dispatch(scopedActions.upsertColumn({
      column: {
        columnHeaderType: 'not-filtered',
        id: fieldId,
        linkField: (_linkFields$fieldId = linkFields[fieldId]) !== null && _linkFields$fieldId !== void 0 ? _linkFields$fieldId : undefined,
        type: column.type,
        aggregatable: column.aggregatable,
        initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH,
        ...initColumnHeader
      },
      id: scopeId,
      index: result.destination != null ? result.destination.index : 0
    }));
  } else if (scopedActions) {
    // create a column definition, because it doesn't exist in the browserFields:
    dispatch(scopedActions.upsertColumn({
      column: {
        columnHeaderType: 'not-filtered',
        id: fieldId,
        initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
      },
      id: scopeId,
      index: result.destination != null ? result.destination.index : 0
    }));
  }
};
exports.addFieldToColumns = addFieldToColumns;
const getIdFromColumnDroppableId = droppableId => droppableId.slice(droppableId.lastIndexOf('.') + 1);
exports.getIdFromColumnDroppableId = getIdFromColumnDroppableId;