"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeCasesPermissions = exports.readCasesPermissions = exports.readCasesCapabilities = exports.noCasesPermissions = exports.noCasesCapabilities = exports.allCasesPermissions = exports.allCasesCapabilities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noCasesCapabilities = () => ({
  create_cases: false,
  read_cases: false,
  update_cases: false,
  delete_cases: false,
  push_cases: false,
  cases_connectors: false,
  cases_settings: false,
  case_reopen: false,
  create_comment: false,
  cases_assign: false
});
exports.noCasesCapabilities = noCasesCapabilities;
const readCasesCapabilities = () => ({
  create_cases: false,
  read_cases: true,
  update_cases: false,
  delete_cases: false,
  push_cases: false,
  cases_connectors: true,
  cases_settings: false,
  case_reopen: false,
  create_comment: false,
  cases_assign: false
});
exports.readCasesCapabilities = readCasesCapabilities;
const allCasesCapabilities = () => ({
  create_cases: true,
  read_cases: true,
  update_cases: true,
  delete_cases: true,
  push_cases: true,
  cases_connectors: true,
  cases_settings: true,
  case_reopen: true,
  create_comment: true,
  cases_assign: true
});
exports.allCasesCapabilities = allCasesCapabilities;
const noCasesPermissions = () => ({
  all: false,
  create: false,
  read: false,
  update: false,
  delete: false,
  push: false,
  connectors: false,
  settings: false,
  reopenCase: false,
  createComment: false,
  assign: false
});
exports.noCasesPermissions = noCasesPermissions;
const readCasesPermissions = () => ({
  all: false,
  create: false,
  read: true,
  update: false,
  delete: false,
  push: false,
  connectors: true,
  settings: false,
  reopenCase: false,
  createComment: false,
  assign: false
});
exports.readCasesPermissions = readCasesPermissions;
const writeCasesPermissions = () => ({
  all: false,
  create: true,
  read: false,
  update: true,
  delete: true,
  push: true,
  connectors: true,
  settings: true,
  reopenCase: true,
  createComment: true,
  assign: true
});
exports.writeCasesPermissions = writeCasesPermissions;
const allCasesPermissions = () => ({
  all: true,
  create: true,
  read: true,
  update: true,
  delete: true,
  push: true,
  connectors: true,
  settings: true,
  reopenCase: true,
  createComment: true,
  assign: true
});
exports.allCasesPermissions = allCasesPermissions;