"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERATION_STARTED_TITLE = exports.GENERATION_STARTED_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERATION_STARTED_TEXT = connectorName => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.useAttackDiscovery.generationStartedToastText', {
  defaultMessage: 'Attack discovery generation started {connectorName, select, undefined {} other { via {connectorName}}}',
  values: {
    connectorName
  }
});
exports.GENERATION_STARTED_TEXT = GENERATION_STARTED_TEXT;
const GENERATION_STARTED_TITLE = exports.GENERATION_STARTED_TITLE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.useAttackDiscovery.generationStartedToastTitle', {
  defaultMessage: 'Generation started'
});