"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConversations = void 0;
var _datemath = require("@kbn/datemath");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _common = require("../../../common");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.conversationMigrationStatus.title', {
  defaultMessage: 'Local storage conversations persisted successfully.'
});
const createConversations = async (notifications, http, storage, currentUser) => {
  // migrate conversations with messages from the local storage
  // won't happen next time
  const conversations = storage.get(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
  if (conversations && Object.keys(conversations).length > 0) {
    const conversationsToCreate = Object.values(conversations).filter(
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    c => c.messages && c.messages.length > 0);
    const transformMessage = m => {
      var _parse, _m$timestamp, _ref, _m$user, _m$content;
      const timestamp = (_parse = (0, _datemath.parse)((_m$timestamp = m.timestamp) !== null && _m$timestamp !== void 0 ? _m$timestamp : '')) === null || _parse === void 0 ? void 0 : _parse.toISOString();
      return {
        ...m,
        ...(m.role === 'user' ? {
          user: (_ref = (_m$user = m.user) !== null && _m$user !== void 0 ? _m$user : currentUser) !== null && _ref !== void 0 ? _ref : {}
        } : {}),
        // message from local storage WILL have content, this is just a fallback
        content: (_m$content = m.content) !== null && _m$content !== void 0 ? _m$content : '',
        timestamp: timestamp == null ? new Date().toISOString() : timestamp,
        reader: undefined // messages from local storage do not have reader
      };
    };
    const connectors = await (0, _constants.loadAllActions)({
      http
    });

    // post bulk create
    const bulkResult = await (0, _elasticAssistant.bulkUpdateConversations)(http, {
      create: conversationsToCreate.reduce(
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (res, c) => {
        var _ref2, _c$id, _c$category, _c$messages, _c$title, _c$replacements;
        // ensure actionTypeId is added to apiConfig from legacy conversation data
        if (c.apiConfig && !c.apiConfig.actionTypeId) {
          const selectedConnector = (connectors !== null && connectors !== void 0 ? connectors : []).find(connector => {
            var _c$apiConfig;
            return connector.id === ((_c$apiConfig = c.apiConfig) === null || _c$apiConfig === void 0 ? void 0 : _c$apiConfig.connectorId);
          });
          if (selectedConnector) {
            c.apiConfig = {
              ...c.apiConfig,
              actionTypeId: selectedConnector.actionTypeId
            };
          } else {
            c.apiConfig = undefined;
          }
        }
        const conversationId = (_ref2 = (_c$id = c.id) !== null && _c$id !== void 0 ? _c$id : c.title) !== null && _ref2 !== void 0 ? _ref2 : (0, _uuid.v4)();
        const fullConversation = {
          ...c,
          id: conversationId,
          category: (_c$category = c.category) !== null && _c$category !== void 0 ? _c$category : 'assistant',
          messages: ((_c$messages = c.messages) !== null && _c$messages !== void 0 ? _c$messages : []).map(transformMessage),
          title: (_c$title = c.title) !== null && _c$title !== void 0 ? _c$title : conversationId,
          replacements: (_c$replacements = c.replacements) !== null && _c$replacements !== void 0 ? _c$replacements : {}
        };
        res[conversationId] = fullConversation;
        return res;
      }, {})
    }, notifications.toasts);
    if (bulkResult && bulkResult.success) {
      var _notifications$toasts;
      storage.remove(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
      (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        iconType: 'check',
        title: LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE
      });
      return true;
    }
    return false;
  }
};
exports.createConversations = createConversations;