"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Temporary hook to get the data view for a given index pattern
 * TODO: use @kbn/cloud-security-posture/src/hooks/use_data_view once
 * Asset Inventory is ready to create data views per space
 */
const useDataView = indexPattern => {
  const {
    data: {
      dataViews
    }
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)(['useDataView', indexPattern], async () => {
    if (!indexPattern) {
      throw new Error('Index pattern is required');
    }
    const [dataView] = await dataViews.find(indexPattern);
    if (!dataView) {
      throw new Error(`Data view not found [${indexPattern}]`);
    }
    return dataView;
  }, {
    retry: false,
    enabled: !!indexPattern
  });
};
exports.useDataView = useDataView;