"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.groupPanelRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _customIcons = require("@kbn/custom-icons");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _asset_criticality = require("../../../../entity_analytics/components/asset_criticality");
var _constants = require("../../../constants");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/grouping/utils/asset_inventory_group_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$cloudProvider, _bucket$cloudProvider2, _bucket$cloudProvider3, _bucket$assetCritical, _bucket$assetCritical2, _bucket$assetCritical3, _bucket$entityType, _bucket$entityType$bu, _bucket$entityType$bu2;
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.LoadingGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  const cloudProvider = (0, _cloudSecurityPosture.firstNonNullValue)((_bucket$cloudProvider = bucket.cloudProvider) === null || _bucket$cloudProvider === void 0 ? void 0 : (_bucket$cloudProvider2 = _bucket$cloudProvider.buckets) === null || _bucket$cloudProvider2 === void 0 ? void 0 : (_bucket$cloudProvider3 = _bucket$cloudProvider2[0]) === null || _bucket$cloudProvider3 === void 0 ? void 0 : _bucket$cloudProvider3.key);
  const renderNullGroup = title => /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.NullGroup, {
    title: title,
    field: selectedGroup,
    unit: _translations.NULL_GROUPING_UNIT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
  const getGroupPanelTitle = aggregationField => {
    var _bucket$aggregationFi, _bucket$aggregationFi2, _bucket$aggregationFi3;
    const aggregationFieldValue = aggregationField ? (_bucket$aggregationFi = bucket[aggregationField]) === null || _bucket$aggregationFi === void 0 ? void 0 : (_bucket$aggregationFi2 = _bucket$aggregationFi.buckets) === null || _bucket$aggregationFi2 === void 0 ? void 0 : (_bucket$aggregationFi3 = _bucket$aggregationFi2[0]) === null || _bucket$aggregationFi3 === void 0 ? void 0 : _bucket$aggregationFi3.key : null;
    if (aggregationFieldValue) {
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 11
        }
      }, aggregationFieldValue), ' - ', bucket.key_as_string);
    }
    return /*#__PURE__*/_react2.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    }, bucket.key_as_string);
  };
  switch (selectedGroup) {
    case _constants.ASSET_GROUPING_OPTIONS.ASSET_CRITICALITY:
      const rawCriticalityLevel = (0, _cloudSecurityPosture.firstNonNullValue)((_bucket$assetCritical = bucket.assetCriticality) === null || _bucket$assetCritical === void 0 ? void 0 : (_bucket$assetCritical2 = _bucket$assetCritical.buckets) === null || _bucket$assetCritical2 === void 0 ? void 0 : (_bucket$assetCritical3 = _bucket$assetCritical2[0]) === null || _bucket$assetCritical3 === void 0 ? void 0 : _bucket$assetCritical3.key);
      const criticalityLevel = rawCriticalityLevel === 'deleted' ? 'unassigned' : rawCriticalityLevel;
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: "unassigned",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 17
        }
      }))))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: criticalityLevel,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 17
        }
      })))));
    case _constants.ASSET_GROUPING_OPTIONS.ENTITY_TYPE:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.ENTITY_TYPE) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react.css)`
                  display: inline;
                `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$entityType = bucket.entityType) === null || _bucket$entityType === void 0 ? void 0 : (_bucket$entityType$bu = _bucket$entityType.buckets) === null || _bucket$entityType$bu === void 0 ? void 0 : (_bucket$entityType$bu2 = _bucket$entityType$bu[0]) === null || _bucket$entityType$bu2 === void 0 ? void 0 : _bucket$entityType$bu2.key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 19
        }
      }, getGroupPanelTitle()))))));
    case _constants.ASSET_GROUPING_OPTIONS.CLOUD_ACCOUNT:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 9
        }
      }, cloudProvider && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_customIcons.CloudProviderIcon, {
        size: "xl",
        cloudProvider: cloudProvider,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 17
        }
      }, getGroupPanelTitle('accountName'))))));
    default:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.DEFAULT) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 17
        }
      }, getGroupPanelTitle())))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const AssetsCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s};
        `,
    color: "hollow",
    "data-test-subj": _constants.TEST_SUBJ_GROUPING_COUNTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(bucket.doc_count)));
};
const AssetsCount = /*#__PURE__*/_react2.default.memo(AssetsCountComponent);
const groupStatsRenderer = (_selectedGroup, bucket) => [{
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.stats.badges.assets', {
    defaultMessage: 'Assets'
  }),
  component: /*#__PURE__*/_react2.default.createElement(AssetsCount, {
    bucket: bucket,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 16
    }
  })
}];
exports.groupStatsRenderer = groupStatsRenderer;