"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredLinks = exports.appLinks = void 0;
var _links = require("../../reports/links");
var _links2 = require("../../configurations/links");
var _links3 = require("../../attack_discovery/links");
var _links4 = require("../../asset_inventory/links");
var _links5 = require("../../siem_readiness/links");
var _links6 = require("../../threat_intelligence/links");
var _links7 = require("../../detections/links");
var _links8 = require("../../rules/links");
var _links9 = require("../../siem_migrations/links");
var _links10 = require("../../timelines/links");
var _links11 = require("../../cases/links");
var _links12 = require("../../management/links");
var _links13 = require("../../explore/links");
var _links14 = require("../../onboarding/links");
var _links15 = require("../../cloud_security_posture/links");
var _links16 = require("../../dashboards/links");
var _links17 = require("../../entity_analytics/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appLinks = exports.appLinks = Object.freeze([_links16.dashboardsLinks, _links7.alertsLink, _links7.alertSummaryLink, _links3.links, _links15.findingsLinks, _links11.links, _links2.configurationsLinks, _links10.links, _links6.indicatorsLinks, _links13.exploreLinks, _links17.entityAnalyticsLinks, _links4.links, _links8.links, _links9.links, _links14.onboardingLinks, _links12.links, _links5.siemReadinessLinks]);
const getFilteredLinks = async (core, plugins) => {
  const managementFilteredLinks = await (0, _links12.getManagementFilteredLinks)(core, plugins);
  const aiValueFilteredLinks = await (0, _links.getAiValueFilteredLinks)(core, plugins);
  const filteredLinks = [_links16.dashboardsLinks, _links7.alertsLink, _links7.alertSummaryLink, _links3.links, _links15.findingsLinks, _links11.links, _links2.configurationsLinks, _links10.links, _links6.indicatorsLinks, _links13.exploreLinks, _links17.entityAnalyticsLinks, _links4.links, _links8.links, _links9.links, _links14.onboardingLinks, managementFilteredLinks, _links5.siemReadinessLinks];

  // Add AI Value links only if user has required role
  if (aiValueFilteredLinks) {
    filteredLinks.push(aiValueFilteredLinks);
  }
  return Object.freeze(filteredLinks);
};
exports.getFilteredLinks = getFilteredLinks;