"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsFieldMap8190 = void 0;
var _ = require("../8.18.0");
var _field_names = require("../field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsFieldMap8190 = exports.alertsFieldMap8190 = {
  ..._.alertsFieldMap8180,
  /**
   * An alternate location for the source data's original data_stream fields. So
   * that they can be used in sorting/filtering, allow multiple values, and not
   * conflict with the official ECS `constant_keyword` mapping for these fields,
   * we apply a `keyword` mapping in this alternate location
   */
  [_field_names.ALERT_ORIGINAL_DATA_STREAM_DATASET]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_field_names.ALERT_ORIGINAL_DATA_STREAM_NAMESPACE]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_field_names.ALERT_ORIGINAL_DATA_STREAM_TYPE]: {
    type: 'keyword',
    array: false,
    required: false
  }
};