"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleKqlQuery = exports.extractRuleEsqlQuery = exports.extractRuleEqlQuery = exports.extractInlineKqlQuery = void 0;
var _prebuilt_rules = require("../../../../api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleKqlQuery = (query, language, filters, savedQueryId) => {
  if (savedQueryId != null) {
    return {
      type: _prebuilt_rules.KqlQueryType.saved_query,
      saved_query_id: savedQueryId
    };
  } else {
    return extractInlineKqlQuery(query, language, filters);
  }
};
exports.extractRuleKqlQuery = extractRuleKqlQuery;
const extractInlineKqlQuery = (query, language, filters) => {
  return {
    type: _prebuilt_rules.KqlQueryType.inline_query,
    query: query !== null && query !== void 0 ? query : '',
    language: language !== null && language !== void 0 ? language : 'kuery',
    filters: filters !== null && filters !== void 0 ? filters : []
  };
};
exports.extractInlineKqlQuery = extractInlineKqlQuery;
const extractRuleEqlQuery = params => {
  var _params$filters;
  return {
    query: params.query,
    language: params.language,
    filters: (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : [],
    event_category_override: params.eventCategoryOverride,
    timestamp_field: params.timestampField,
    tiebreaker_field: params.tiebreakerField
  };
};
exports.extractRuleEqlQuery = extractRuleEqlQuery;
const extractRuleEsqlQuery = (query, language) => {
  return {
    query,
    language
  };
};
exports.extractRuleEsqlQuery = extractRuleEsqlQuery;