/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.security_bundle_jsonpfunction=self.security_bundle_jsonpfunction||[]).push([[39],{7121:(s,e,a)=>{a.d(e,{g:()=>ChangePasswordForm});var t=a(3185),r=a(8915),o=a(1319),d=a(770),n=a.n(d),i=a(4286),u=a(5008),l=a(5879),c=a(6791);class ChangePasswordForm extends i.Component{constructor(s){super(s),(0,r.default)(this,"getForm",(()=>(0,c.jsx)(o.EuiForm,null,this.props.isUserChangingOwnPassword&&(0,c.jsx)(o.EuiFormRow,(0,t.default)({},this.validateCurrentPassword(),{fullWidth:!0,label:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.currentPasswordLabel",defaultMessage:"Current password"})}),(0,c.jsx)(o.EuiFieldPassword,{autoComplete:"off","data-test-subj":"currentPassword",type:"dual",value:this.state.currentPassword,onChange:this.onCurrentPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),(0,c.jsx)(o.EuiFormRow,(0,t.default)({helpText:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.passwordRequirements",defaultMessage:"Use at least 6 characters."})},this.validateNewPassword(),{fullWidth:!0,label:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.newPasswordLabel",defaultMessage:"New password"})}),(0,c.jsx)(o.EuiFieldPassword,{autoComplete:"new-password","data-test-subj":"newPassword",type:"dual",value:this.state.newPassword,onChange:this.onNewPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),(0,c.jsx)(o.EuiFormRow,(0,t.default)({},this.validateConfirmPassword(),{fullWidth:!0,label:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.confirmPasswordLabel",defaultMessage:"Confirm new password"})}),(0,c.jsx)(o.EuiFieldPassword,{autoComplete:"new-password","data-test-subj":"confirmNewPassword",type:"dual",value:this.state.confirmPassword,onChange:this.onConfirmPasswordChange,disabled:this.state.changeInProgress,fullWidth:!0})),(0,c.jsx)(o.EuiFormRow,null,(0,c.jsx)(o.EuiFlexGroup,{alignItems:"center",responsive:!1},(0,c.jsx)(o.EuiFlexItem,{grow:!1},(0,c.jsx)(o.EuiButton,{onClick:this.onChangePasswordClick,fill:!0,isLoading:this.state.changeInProgress,"data-test-subj":"changePasswordButton"},(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.saveChangesButtonLabel",defaultMessage:"Change password"}))),(0,c.jsx)(o.EuiFlexItem,{grow:!1},(0,c.jsx)(o.EuiButtonEmpty,{onClick:this.onCancelClick,isDisabled:this.state.changeInProgress},(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.cancelButtonLabel",defaultMessage:"Reset"})))))))),(0,r.default)(this,"onCurrentPasswordChange",(s=>{this.setState({currentPassword:s.target.value,currentPasswordError:!1})})),(0,r.default)(this,"onNewPasswordChange",(s=>{this.setState({newPassword:s.target.value})})),(0,r.default)(this,"onConfirmPasswordChange",(s=>{this.setState({confirmPassword:s.target.value})})),(0,r.default)(this,"onCancelClick",(()=>{this.setState({shouldValidate:!1,currentPassword:"",newPassword:"",confirmPassword:"",currentPasswordError:!1,changeInProgress:!1})})),(0,r.default)(this,"onChangePasswordClick",(async()=>{this.setState({shouldValidate:!0,currentPasswordError:!1},(()=>{const{isInvalid:s}=this.validateForm();s||this.setState({changeInProgress:!0},(()=>this.performPasswordChange()))}))})),(0,r.default)(this,"validateCurrentPassword",((s=this.state.shouldValidate)=>s&&this.props.isUserChangingOwnPassword?this.state.currentPasswordError?{isInvalid:!0,error:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.changePasswordForm.invalidPassword",defaultMessage:"Current password is incorrect."})}:this.state.currentPassword?{isInvalid:!1}:{isInvalid:!0,error:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.currentPasswordRequired",defaultMessage:"Current password is required."})}:{isInvalid:!1})),(0,r.default)(this,"validateNewPassword",((s=this.state.shouldValidate)=>{const{newPassword:e}=this.state;return s&&e.length<6?{isInvalid:!0,error:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.passwordLengthDescription",defaultMessage:"Password is too short."})}:{isInvalid:!1}})),(0,r.default)(this,"validateConfirmPassword",((s=this.state.shouldValidate)=>{const{newPassword:e,confirmPassword:a}=this.state;return s&&e!==a?{isInvalid:!0,error:(0,c.jsx)(l.FormattedMessage,{id:"xpack.security.account.passwordsDoNotMatch",defaultMessage:"Passwords do not match."})}:{isInvalid:!1}})),(0,r.default)(this,"validateForm",(()=>[this.validateCurrentPassword(!0),this.validateNewPassword(!0),this.validateConfirmPassword(!0)].find((s=>s.isInvalid))||{isInvalid:!1})),(0,r.default)(this,"performPasswordChange",(async()=>{try{await this.props.userAPIClient.changePassword(this.props.user.username,this.state.newPassword,this.state.currentPassword),this.handleChangePasswordSuccess()}catch(s){this.handleChangePasswordFailure(s)}finally{this.setState({changeInProgress:!1})}})),(0,r.default)(this,"handleChangePasswordSuccess",(()=>{this.props.notifications.toasts.addSuccess({title:u.i18n.translate("xpack.security.account.changePasswordSuccess",{defaultMessage:"Your password has been changed."}),"data-test-subj":"passwordUpdateSuccess"}),this.setState({currentPasswordError:!1,shouldValidate:!1,newPassword:"",currentPassword:"",confirmPassword:""}),this.props.onChangePassword&&this.props.onChangePassword()})),(0,r.default)(this,"handleChangePasswordFailure",(s=>{s.body&&403===s.body.statusCode?this.setState({currentPasswordError:!0}):this.props.notifications.toasts.addDanger(u.i18n.translate("xpack.security.management.users.editUser.settingPasswordErrorMessage",{defaultMessage:"Error setting password: {message}",values:{message:n().get(s,"body.message")}}))})),this.state={shouldValidate:!1,currentPassword:"",newPassword:"",confirmPassword:"",currentPasswordError:!1,changeInProgress:!1}}render(){return this.getForm()}}},3039:(s,e,a)=>{a.d(e,{ChangePassword:()=>ChangePassword});var t=a(8915),r=a(1319),o=a(4286),d=a(5879),n=a(1672),i=a(7121),u=a(6791);class ChangePassword extends o.Component{constructor(...s){super(...s),(0,t.default)(this,"getChangePasswordForm",(s=>(0,u.jsx)(r.EuiDescribedFormGroup,{fullWidth:!0,title:(0,u.jsx)("h2",null,s),description:(0,u.jsx)("p",null,(0,u.jsx)(d.FormattedMessage,{id:"xpack.security.account.changePasswordDescription",defaultMessage:"Change the password for your account."}))},(0,u.jsx)(i.g,{user:this.props.user,isUserChangingOwnPassword:!0,userAPIClient:this.props.userAPIClient,notifications:this.props.notifications}))))}render(){const s=(0,n.RP)(this.props.user),e=(0,u.jsx)(d.FormattedMessage,{id:"xpack.security.account.changePasswordTitle",defaultMessage:"Password"});return s?this.getChangePasswordForm(e):this.getChangePasswordUnavailable(e)}getChangePasswordUnavailable(s){return(0,u.jsx)(r.EuiDescribedFormGroup,{fullWidth:!0,title:(0,u.jsx)("h3",null,s),description:(0,u.jsx)("p",null,(0,u.jsx)(d.FormattedMessage,{id:"xpack.security.account.changePasswordNotSupportedText",defaultMessage:"You cannot change the password for this account."}))},(0,u.jsx)("div",null))}}}}]);