"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProviderFromActionTypeId = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProviderFromActionTypeId = actionTypeId => {
  const providerDictionary = {
    [`.gen-ai`]: `openai`,
    [`.bedrock`]: `bedrock`,
    [`.gemini`]: `gemini`,
    [`.inference`]: `inference`
  };
  return providerDictionary[actionTypeId];
};
exports.getProviderFromActionTypeId = getProviderFromActionTypeId;