"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_PAGE_VALUE = void 0;
exports.pageToPagination = pageToPagination;
exports.paginationToPage = paginationToPage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_VALUE = exports.DEFAULT_PAGE_VALUE = {
  from: 0,
  size: 25
};
function paginationToPage(pagination) {
  return {
    from: pagination.pageIndex * pagination.pageSize,
    size: pagination.pageSize
  };
}
function pageToPagination(page) {
  // Prevent divide-by-zero-error
  const pageIndex = page.size ? Math.trunc(page.from / page.size) : 0;
  return {
    pageIndex,
    pageSize: page.size,
    totalItemCount: page.total
  };
}