"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteRuleset = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteRuleset = (onSuccess, onError) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(async ({
    rulesetId
  }) => {
    return await http.delete(`/internal/search_query_rules/ruleset/${rulesetId}`);
  }, {
    onSuccess: (_, {
      rulesetId
    }) => {
      var _notifications$toasts;
      queryClient.invalidateQueries([_constants.QUERY_RULES_SETS_QUERY_KEY]);
      notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.queryRules.deleteRulesetSuccess', {
          defaultMessage: 'Ruleset {rulesetId} deleted',
          values: {
            rulesetId
          }
        })
      });
      if (onSuccess) {
        onSuccess();
      }
    },
    onError: error => {
      if (onError) {
        onError(error.body.message);
      } else {
        var _notifications$toasts2;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts2 = notifications.toasts) === null || _notifications$toasts2 === void 0 ? void 0 : _notifications$toasts2.addError(new Error(error.body.message), {
          title: _i18n.i18n.translate('xpack.queryRules.deleteRulesetError', {
            defaultMessage: 'Error deleting ruleset'
          }),
          toastMessage: error.body.message
        });
      }
    }
  });
};
exports.useDeleteRuleset = useDeleteRuleset;