"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceProviderFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _multi_select_filter = require("./multi_select_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/all_inference_endpoints/filter/service_provider_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServiceProviderFilter = ({
  optionKeys,
  onChange,
  uniqueProviders
}) => {
  const filterId = 'provider';
  const onSystemFilterChange = newOptions => {
    onChange({
      [filterId]: newOptions.filter(option => option.checked === 'on').map(option => option.key)
    });
  };
  const filteredOptions = (0, _react.useMemo)(() => {
    const options = [];
    uniqueProviders.forEach(provider => {
      const {
        name
      } = _inferenceEndpointUiCommon.SERVICE_PROVIDERS[provider];
      options.push({
        key: provider,
        label: name
      });
    });
    return options;
  }, [uniqueProviders]);
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.SERVICE_PROVIDER,
    onChange: onSystemFilterChange,
    options: filteredOptions,
    renderOption: option => option.label,
    selectedOptionKeys: optionKeys,
    dataTestSubj: "service-field-endpoints",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.ServiceProviderFilter = ServiceProviderFilter;