"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatelessHeaderPromo = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _promo = require("./promo");
var _cta_link = require("./cta_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/header/stateless_promo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatelessHeaderPromo = () => {
  return /*#__PURE__*/_react.default.createElement(_promo.HeaderPromo, {
    title: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo.title', {
      defaultMessage: 'GPUs go brrr! GPU-accelerated inference for ELSER'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo.description', {
      defaultMessage: 'We are thrilled to launch ELSER on ElS -- get state-of-the-art semantic search relevance without having to manage your own machine learning nodes.'
    }),
    cta: /*#__PURE__*/_react.default.createElement(_cta_link.HeaderCTALink
    // "search-promo-homepage-" is prepended to the telemetry id in HeaderCTALink
    , {
      "data-telemetry-id": "11-elser-on-eis",
      href: "https://www.elastic.co/docs/explore-analyze/elastic-inference/eis#elser-on-eis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchHomepage.statelessPromo.content', {
      defaultMessage: 'View docs'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
};
exports.StatelessHeaderPromo = StatelessHeaderPromo;