"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AISearchCapabilities = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _keyword_search = require("./keyword_search");
var _semantic_search = require("./semantic_search");
var _vector_search = require("./vector_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/ai_search_capabilities/ai_search_capabilities.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_CAPABILITIES = [{
  label: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.semanticSearch', {
    defaultMessage: 'Semantic search'
  }),
  value: 'semantic'
}, {
  label: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch', {
    defaultMessage: 'Vector search'
  }),
  value: 'vector'
}, {
  label: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.keywordSearch', {
    defaultMessage: 'Keyword search'
  }),
  value: 'keyword'
}];
const capabilityComponents = {
  semantic: _semantic_search.SemanticSearch,
  vector: _vector_search.VectorSearch,
  keyword: _keyword_search.KeywordSearch
};
const AISearchCapabilities = () => {
  const [selectedCapability, setSelectedCapability] = (0, _react.useState)(SEARCH_CAPABILITIES[0].value);
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const SelectedComponent = capabilityComponents[selectedCapability];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.title', {
    defaultMessage: 'Explore Elastic’s AI search capabilities'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    direction: currentBreakpoint === 's' || currentBreakpoint === 'm' ? 'column' : 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, SEARCH_CAPABILITIES.map(capability => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: capability.value,
    color: "primary",
    label: capability.label,
    onClick: () => setSelectedCapability(capability.value),
    isActive: selectedCapability === capability.value,
    "data-test-subj": `aiSearchCapabilities-item-${capability.value}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(SelectedComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  })))));
};
exports.AISearchCapabilities = AISearchCapabilities;