"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveDiscoverSession = void 0;
var _common = require("@kbn/data-plugin/common");
var _constants = require("./constants");
var _check_for_duplicate_title = require("./check_for_duplicate_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const saveDiscoverSessionSavedObject = async (id, attributes, references, contentManagement) => {
  const resp = id ? await contentManagement.update({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    id,
    data: attributes,
    options: {
      references
    }
  }) : await contentManagement.create({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    data: attributes,
    options: {
      references
    }
  });
  return resp.item.id;
};
const saveDiscoverSession = async (discoverSession, options, contentManagement, savedObjectsTagging) => {
  var _discoverSession$tags;
  const isNew = options.copyOnSave || !discoverSession.id;
  if (isNew) {
    try {
      await (0, _check_for_duplicate_title.checkForDuplicateTitle)({
        title: discoverSession.title,
        isTitleDuplicateConfirmed: options.isTitleDuplicateConfirmed,
        onTitleDuplicate: options.onTitleDuplicate,
        contentManagement
      });
    } catch {
      return;
    }
  }
  const tabReferences = [];

  // TODO: SavedSearchAttributes['tabs'] shouldn't be nullable soon
  const tabs = discoverSession.tabs.map(tab => {
    const [serializedSearchSource, searchSourceReferences] = (0, _common.extractReferences)(tab.serializedSearchSource, {
      refNamePrefix: `tab_${tab.id}`
    });
    tabReferences.push(...searchSourceReferences);
    return {
      id: tab.id,
      label: tab.label,
      attributes: {
        sort: tab.sort,
        columns: tab.columns,
        grid: tab.grid,
        hideChart: tab.hideChart,
        isTextBasedQuery: tab.isTextBasedQuery,
        usesAdHocDataView: tab.usesAdHocDataView,
        kibanaSavedObjectMeta: {
          searchSourceJSON: JSON.stringify(serializedSearchSource)
        },
        viewMode: tab.viewMode,
        hideAggregatedPreview: tab.hideAggregatedPreview,
        rowHeight: tab.rowHeight,
        headerRowHeight: tab.headerRowHeight,
        timeRestore: tab.timeRestore,
        timeRange: tab.timeRange,
        refreshInterval: tab.refreshInterval,
        rowsPerPage: tab.rowsPerPage,
        sampleSize: tab.sampleSize,
        breakdownField: tab.breakdownField,
        density: tab.density,
        visContext: tab.visContext,
        controlGroupJson: tab.controlGroupJson
      }
    };
  });
  const attributes = {
    title: discoverSession.title,
    description: discoverSession.description,
    tabs,
    // TODO: Spreading the first tab attributes like this shouldn't be necessary soon
    ...tabs[0].attributes,
    sort: tabs[0].attributes.sort,
    density: tabs[0].attributes.density
  };
  const references = savedObjectsTagging ? savedObjectsTagging.ui.updateTagsReferences(tabReferences, (_discoverSession$tags = discoverSession.tags) !== null && _discoverSession$tags !== void 0 ? _discoverSession$tags : []) : tabReferences;
  const id = await saveDiscoverSessionSavedObject(isNew ? undefined : discoverSession.id, attributes, references, contentManagement);
  return {
    ...discoverSession,
    id,
    references,
    managed: false
  };
};
exports.saveDiscoverSession = saveDiscoverSession;