"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse = exports.joi2JsonInternal = exports.isJoiToJsonSpecialSchemas = void 0;
var _joiToJson = _interopRequireDefault(require("joi-to-json"));
var _lodash = require("lodash");
var _post_process_mutations = require("./post_process_mutations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isJoiToJsonSpecialSchemas = parseResult => {
  return 'schemas' in parseResult;
};
exports.isJoiToJsonSpecialSchemas = isJoiToJsonSpecialSchemas;
const joi2JsonInternal = schema => {
  return (0, _joiToJson.default)(schema, 'open-api');
};
exports.joi2JsonInternal = joi2JsonInternal;
const parse = ({
  schema,
  ctx = (0, _post_process_mutations.createCtx)()
}) => {
  const parsed = joi2JsonInternal(schema);
  let result;
  if (isJoiToJsonSpecialSchemas(parsed)) {
    Object.entries(parsed.schemas).forEach(([id, s]) => {
      (0, _post_process_mutations.postProcessMutations)({
        schema: s,
        ctx
      });
      ctx.addSharedSchema(id, s);
    });
    result = (0, _lodash.omit)(parsed, 'schemas');
  } else {
    result = parsed;
  }
  (0, _post_process_mutations.postProcessMutations)({
    schema: result,
    ctx
  });
  return {
    shared: ctx.getSharedSchemas(),
    result
  };
};
exports.parse = parse;