"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsMonitorStatusRuleParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TimeWindowSchema = _configSchema.schema.object({
  unit: _configSchema.schema.oneOf([_configSchema.schema.literal('s'), _configSchema.schema.literal('m'), _configSchema.schema.literal('h'), _configSchema.schema.literal('d')], {
    defaultValue: 'm'
  }),
  size: _configSchema.schema.number({
    defaultValue: 5
  })
});
const NumberOfChecksSchema = _configSchema.schema.object({
  numberOfChecks: _configSchema.schema.number({
    defaultValue: 5,
    min: 1,
    max: 100
  })
});
const StatusRuleConditionSchema = _configSchema.schema.object({
  groupBy: _configSchema.schema.maybe(_configSchema.schema.string({
    defaultValue: 'locationId'
  })),
  downThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: 3
  })),
  locationsThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: 1
  })),
  window: _configSchema.schema.oneOf([_configSchema.schema.object({
    time: TimeWindowSchema
  }), NumberOfChecksSchema]),
  includeRetests: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  recoveryStrategy: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('firstUp'), _configSchema.schema.literal('conditionNotMet')]))
});
const syntheticsMonitorStatusRuleParamsSchema = exports.syntheticsMonitorStatusRuleParamsSchema = _configSchema.schema.object({
  condition: _configSchema.schema.maybe(StatusRuleConditionSchema),
  monitorIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  locations: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  monitorTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  projects: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  kqlQuery: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  meta: {
    description: 'The parameters for the rule.'
  }
});