"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.authorizedUserPreRouting = void 0;
var _get_user = require("./get_user");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const authorizedUserPreRouting = (reporting, handler) => {
  const {
    logger,
    security: securitySetup
  } = reporting.getPluginSetupDeps(); // ReportingInternalSetup.security?: SecurityPluginSetup | undefined

  return async (context, req, res) => {
    const {
      securityService
    } = await reporting.getPluginStartDeps();
    try {
      let user = false;
      if (securitySetup && securitySetup.license.isEnabled()) {
        // find the authenticated user, only if license is enabled
        user = (0, _get_user.getUser)(req, securityService);
        if (!user) {
          // security is enabled but the user is null
          return res.unauthorized({
            body: `Sorry, you aren't authenticated`
          });
        }
      }
      return handler(user, context, req, res);
    } catch (err) {
      logger.error(err);
      return res.custom({
        statusCode: 500
      });
    }
  };
};
exports.authorizedUserPreRouting = authorizedUserPreRouting;