"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkDelete = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _reportingPublic = require("@kbn/reporting-public");
var _bulk_delete_scheduled_reports = require("../apis/bulk_delete_scheduled_reports");
var _mutation_keys = require("../mutation_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = _mutation_keys.mutationKeys.bulkDeleteScheduledReports;
const useBulkDelete = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _reportingPublic.useKibana)().services;
  return (0, _reactQuery.useMutation)({
    mutationKey: getKey(),
    mutationFn: ({
      ids
    }) => (0, _bulk_delete_scheduled_reports.bulkDeleteScheduledReports)({
      http,
      ids
    }),
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.reporting.schedules.reports.deleteError', {
          defaultMessage: 'Error deleting scheduled report'
        })
      });
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.reporting.schedules.reports.deleted', {
        defaultMessage: 'Scheduled report deleted'
      }));
      queryClient.invalidateQueries({
        queryKey: ['reporting', 'scheduledList'],
        refetchType: 'active'
      });
    }
  });
};
exports.useBulkDelete = useBulkDelete;