"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracker = getTracker;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TRANSACTION_TYPE = 'reporting';
const SPANTYPE_SETUP = 'setup';
function getTracker() {
  const apmTrans = _elasticApmNode.default.startTransaction('generate-pdf', TRANSACTION_TYPE);
  let apmScreenshots = null;
  return {
    startScreenshots() {
      apmScreenshots = apmTrans.startSpan('screenshots-pipeline', SPANTYPE_SETUP) || null;
    },
    endScreenshots() {
      if (apmScreenshots) apmScreenshots.end();
    },
    setCpuUsage(cpu) {
      apmTrans.setLabel('cpu', cpu, false);
    },
    setMemoryUsage(memory) {
      apmTrans.setLabel('memory', memory, false);
    },
    end() {
      if (apmTrans) apmTrans.end();
    }
  };
}