"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cli = cli;
var path = _interopRequireWildcard(require("path"));
var _generate = require("./generate");
var _sort_yaml = require("./sort_yaml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable no-console */

function cli() {
  console.log('🚀 Starting OpenTelemetry Semantic Conventions processing...');
  const packageRoot = path.resolve(__dirname, '../');
  const yamlPath = path.join(packageRoot, 'assets', 'resolved-semconv.yaml');

  // Step 1: Sort YAML for deterministic ordering
  try {
    console.log('📋 Sorting YAML for deterministic field ordering...');
    (0, _sort_yaml.sortYamlFile)(yamlPath, yamlPath); // Sort in place
    console.log('✅ YAML sorted successfully');
  } catch (error) {
    const errorMessage = error instanceof Error ? error.message : String(error);
    console.error(`❌ YAML sorting failed: ${errorMessage}`);
    console.error(`📁 YAML file path: ${yamlPath}`);
    process.exit(1);
  }

  // Step 2: Generate TypeScript from the sorted YAML
  try {
    (0, _generate.runGenerateOtelSemconvCli)();
    console.log('✅ OpenTelemetry semantic conventions generation completed successfully!');
    process.exit(0);
  } catch (error) {
    const errorMessage = error instanceof Error ? error.message : String(error);
    console.error(`❌ TypeScript generation failed: ${errorMessage}`);
    console.error(`📁 YAML source: ${yamlPath}`);
    process.exit(1);
  }
}