"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSavedQueryPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../../../common/lib/kibana");
var _layouts = require("../../../components/layouts");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _form = require("./form");
var _saved_queries = require("../../../saved_queries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/saved_queries/edit/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiCalloutCss = {
  margin: '10px'
};
const EditSavedQueryPageComponent = () => {
  var _savedQueryDetails$sa;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const {
    savedQueryId
  } = (0, _reactRouterDom.useParams)();
  const savedQueryListProps = (0, _kibana.useRouterNavigate)('saved_queries');
  const {
    isLoading,
    data: savedQueryDetails
  } = (0, _saved_queries.useSavedQuery)({
    savedQueryId
  });
  const updateSavedQueryMutation = (0, _saved_queries.useUpdateSavedQuery)({
    savedQueryId
  });
  const deleteSavedQueryMutation = (0, _saved_queries.useDeleteSavedQuery)({
    savedQueryId
  });
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_query_edit', {
    savedQueryName: (_savedQueryDetails$sa = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.saved_object_id) !== null && _savedQueryDetails$sa !== void 0 ? _savedQueryDetails$sa : ''
  });
  const elasticPrebuiltQuery = (0, _react.useMemo)(() => !!(savedQueryDetails !== null && savedQueryDetails !== void 0 && savedQueryDetails.prebuilt), [savedQueryDetails]);
  const viewMode = (0, _react.useMemo)(() => !permissions.writeSavedQueries || elasticPrebuiltQuery, [permissions.writeSavedQueries, elasticPrebuiltQuery]);
  const handleCloseDeleteConfirmationModal = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(false);
  }, []);
  const handleDeleteClick = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(true);
  }, []);
  const handleDeleteConfirmClick = (0, _react.useCallback)(() => {
    deleteSavedQueryMutation.mutateAsync().then(() => {
      handleCloseDeleteConfirmationModal();
    });
  }, [deleteSavedQueryMutation, handleCloseDeleteConfirmationModal]);
  const LeftColumn = (0, _react.useMemo)(() => {
    var _savedQueryDetails$id, _savedQueryDetails$id2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      direction: "column",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      iconType: "arrowLeft"
    }, savedQueryListProps, {
      flush: "left",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.editSavedQuery.viewSavedQueriesListTitle",
      defaultMessage: "View all saved queries",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, viewMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.viewSavedQuery.pageTitle",
      defaultMessage: "\"{savedQueryId}\" details"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        savedQueryId: (_savedQueryDetails$id = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id) !== null && _savedQueryDetails$id !== void 0 ? _savedQueryDetails$id : ''
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 19
      }
    }), elasticPrebuiltQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      css: euiCalloutCss,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.viewSavedQuery.prebuiltInfo",
      defaultMessage: "This is a prebuilt Elastic query, and it cannot be edited.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 23
      }
    }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.editSavedQuery.pageTitle",
      defaultMessage: "Edit \"{savedQueryId}\""
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        savedQueryId: (_savedQueryDetails$id2 = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id) !== null && _savedQueryDetails$id2 !== void 0 ? _savedQueryDetails$id2 : ''
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    })))));
  }, [elasticPrebuiltQuery, savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id, savedQueryListProps, viewMode]);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleDeleteClick,
    iconType: "trash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editSavedQuery.deleteSavedQueryButtonLabel",
    defaultMessage: "Delete query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  })), [handleDeleteClick]);
  const titleProps = (0, _react.useMemo)(() => ({
    id: confirmModalTitleId
  }), [confirmModalTitleId]);
  const handleSubmit = (0, _react.useCallback)(async payload => {
    await updateSavedQueryMutation.mutateAsync(payload);
  }, [updateSavedQueryMutation]);
  if (isLoading) return null;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: !viewMode ? RightColumn : undefined,
    rightColumnGrow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, !isLoading && !(0, _fp.isEmpty)(savedQueryDetails) && /*#__PURE__*/_react.default.createElement(_form.EditSavedQueryForm, {
    defaultValue: savedQueryDetails,
    handleSubmit: handleSubmit,
    viewMode: viewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }), isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: titleProps,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.title",
      defaultMessage: "Are you sure you want to delete this query?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 13
      }
    }),
    onCancel: handleCloseDeleteConfirmationModal,
    onConfirm: handleDeleteConfirmClick,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.confirmButtonLabel",
      defaultMessage: "Confirm",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 13
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.deleteSavedQuery.confirmationModal.body",
    defaultMessage: "You're about to delete this query. Are you sure you want to do this?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  })) : null);
};
const EditSavedQueryPage = exports.EditSavedQueryPage = /*#__PURE__*/_react.default.memo(EditSavedQueryPageComponent);